#ifndef QRK_OBJECT_MAP_H
#define QRK_OBJECT_MAP_H

/*!
  \file
  \brief 環境マップ

  \author Satofumi KAMIMURA

  $Id: ObjectMap.h 1495 2009-11-03 11:27:55Z satofumi $
*/

#include "pole_t.h"
#include "line_t.h"
#include <vector>
#include <memory>


namespace qrk
{
  class ObjectMap
  {
  public:
    enum {
      InvalidTimestamp = -1,
    };

    ObjectMap(void);
    //ObjectMap(size_t grid_width);
    ~ObjectMap(void);

    void setTimestamp(long timestamp);
    long timestamp(void) const;

    void addPole(const pole_t& pole, size_t id);
    bool poleExists(size_t id) const;
    void mergePole(size_t id, const pole_t& pole);
    pole_t pole(size_t id) const;
    std::vector<size_t> poles(void) const;

    //! 指定した位置周辺の点群を受け取る
    void nearPoles(std::vector<size_t>& ids,
                   const pole_t& pole, long radius) const;

    void addLine(const line_t& line, size_t id);
    bool lineExist(size_t id) const;
    line_t line(size_t id) const;
    std::vector<size_t> lines(void) const;
    void nearLines(std::vector<size_t>& ids,
                   const line_t& line, long radius) const;

  private:
    ObjectMap(const ObjectMap& rhs);
    ObjectMap& operator = (const ObjectMap& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_OBJECT_MAP_H */
