/*!
  \file
  \brief 経路探索のサンプル

  \author Satofumi KAMIMURA

  $Id: searchPathSample.cpp 1340 2009-09-27 17:26:26Z satofumi $
*/

#include "SearchPath.h"
#include <iostream>

using namespace qrk;
using namespace std;


namespace
{
  void printMap(string map[], size_t height)
  {
    for (size_t y = 0; y < height; ++y) {
      cout << map[y] << endl;
    }
  }
}

int main(int argc, char *argv[])
{
  (void)argc;
  (void)argv;

  // S: スタート
  // G: ゴール
  // #: 障害物
  string map[] = {
    "     ",
    "S#   ",
    "#### ",
    "     ",
    " ####",
    "G    ",
  };
  size_t height = sizeof(map) / sizeof(map[0]);
  if (height == 0) {
    cout << "Invalid map: height";
    return 1;
  }
  size_t width = map[0].size();
  if (height == 0) {
    cout << "Invalid map: width";
    return 1;
  }

  //cout << "map size (" << width << ", " << height << ")" << endl;
  SearchPath path_grid(width, height);

  for (size_t y = 0; y < height; ++y) {
    for (size_t x = 0; x < width; ++x) {
      char ch = map[y][x];
      if (ch == 'G') {
        path_grid.setGoal(x, y);
      } else if (ch == 'S') {
        path_grid.setStart(x, y);
      } else if (ch == '#') {
        path_grid.setObstacle(x, y);
      }
    }
  }

  vector<Point<long> > points;
  path_grid.path(points);

  size_t n = points.size();
  for (size_t i = 0; i < n - 1; ++i) {
    Point<long>& p = points[i];
    map[p.y][p.x] = '.';
  }

  printMap(map, height);

  return 0;
}
