/*!
  \file
  \brief データ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdScanSample.cpp 776 2009-05-05 08:09:30Z satofumi $
*/

#include "mUrgCtrl.h"
#include <SDL.h>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[]) {

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0";

  mUrgCtrl urg(argc, argv);
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // データ取得
  vector<long> data;
  long timestamp = 0;
  int n = urg.capture(data, &timestamp);
  printf("n = %d\n", n);
  if (n < 0) {
    printf("UrgCtrl::capture: %s\n", urg.what());
    exit(1);
  }

  printf("timestamp: %ld\n", timestamp);
  for (int i = 0; i < n; ++i) {
    printf("%ld, ", data[i]);
  }
  printf("\n");

  return 0;
}
