#ifndef SCIP_HANDLER_10_H
#define SCIP_HANDLER_10_H

/*!
  \file
  \brief handler SCIP 1.0 protocol

  \author Satofumi Kamimura

  $Id: scip_handler_10.h 1984 2012-04-16 03:36:49Z satofumi $
*/

#include "serial_t.h"


enum {
  ScipNoWaitReply = 0,          /*!< Dont wait for reply */
  ScipWaitReply = 1,            /*!< Wait for reply */
  ScipLineWidth = 64 + 1 + 1,   /*!< Maximum length of one line */
};


extern int scip_send(serial_t *serial, const char *send_command);
extern int scip_recv(serial_t *serial, const char *command_first,
                     int* return_code, int expected_ret[],
                     int timeout);
extern int scip_q(serial_t *serial, int *return_code, int wait_reply);
extern int scip_v(serial_t *serial, char *lines[], int lines_max);
extern int scip_s(serial_t *serial, long baudrate);

#endif
