/*!
  \example lua/move_astar.cpp

  \brief 「A* アルゴリズムを用いた障害物回避」サンプル

  \author Satofumi KAMIMURA

  $Id: move_astar.cpp 1396 2009-10-11 00:22:32Z satofumi $
*/

#include <qrk_main.h>
#include <LuaHandler.h>
#include <luabindInit.h>
#include <luabindBeegoDrive.h>
#include <luabindRangeFinder.h>

using namespace qrk;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  lua_State* L = luabindInit();
  luabindBeegoDrive(L);
  luabindRangeFinder(L);
  return LuaHandler::dofile(L, "move_astar.lua");
}
