/*!
  \file
  \brief Lua への UrgDistance モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindUrgDistance.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "luabindUrgDistance.h"
#include "mUrgDistance.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindUrgDistance(lua_State* L)
{
    module(L)
        [
         class_<mUrgDistance>("mUrgDistance")
         .def(constructor<>())
         .def("what", &mUrgDistance::what)
         .def("connect", &mUrgDistance::connect)
         .def("disconnect", &mUrgDistance::disconnect)
         .def("minDistance", &mUrgDistance::minDistance)
         .def("requestData", &mUrgDistance::requestData)
         .def("receiveData",
              (bool(mUrgDistance::*)(void)) &mUrgDistance::receiveData)
         .def("at", &mUrgDistance::at)
         .def("deg2index", &mUrgDistance::deg2index)
         ];
}
