#ifndef QRK_GL_DRAW_H
#define QRK_GL_DRAW_H

/*!
  \file
  \brief OpenGL での描画処理

  \author Satofumi KAMIMURA

  $Id: gl_draw.h 1267 2009-08-30 12:51:46Z satofumi $
*/

#include <ode/ode.h>


namespace qrk
{
  class Color;


  void gl_loadIdentity(void);
  void gl_moved(dBodyID id);
  void gl_setColor(const Color& color);
  void gl_drawBox(const dReal length[], bool wireframe = false);
  void gl_drawCylinder(const dReal length[], bool wireframe = false);
  void gl_drawSphere(dBodyID id, const dReal length[], bool wireframe = false);
  void gl_drawGround(void);
}

#endif /* !QRK_GL_DRAW_H */
