/*!
  \file
  \brief モデルの管理

  \author Satofumi KAMIMURA

  $Id: ModelManager.cpp 1422 2009-10-18 13:48:05Z satofumi $
*/

#include "ModelManager.h"

using namespace qrk;
using namespace std;


struct ModelManager::pImpl
{
  Models models_;
  set<dBodyID> obstacle_;


  pImpl(void)
  {
  }


  static pImpl* object(void)
  {
    static pImpl singleton_object;
    return &singleton_object;
  }


  void add(const model_t* model)
  {
    models_.insert(model);
    if (model->obstacle) {
      obstacle_.insert(model->body_id);
    }
  }
};


ModelManager::ModelManager(void) : pimpl(pImpl::object())
{
}


ModelManager::~ModelManager(void)
{
}


void ModelManager::clear(void)
{
  pimpl->models_.clear();
}


bool ModelManager::empty(void) const
{
  return pimpl->models_.empty();
}


void ModelManager::addBox(model_t* model, const dReal length[])
{
  for (size_t i = 0; i < 3; ++i) {
    model->length[i] = length[i];
  }
  pimpl->add(model);
}


void ModelManager::addCylinder(model_t* model, dReal radius, dReal length)
{
  model->length[0] = radius;
  model->length[1] = length;
  pimpl->add(model);
}


void ModelManager::addSphere(model_t* model, dReal radius)
{
  model->length[0] = radius;
  pimpl->add(model);
}


void ModelManager::remove(const model_t* model)
{
  pimpl->obstacle_.erase(model->body_id);
  pimpl->models_.erase(model);
}


bool ModelManager::obstacle(dBodyID id) const
{
  return (pimpl->obstacle_.find(id) != pimpl->obstacle_.end()) ? true : false;
}


const ModelManager::Models ModelManager::models(void) const
{
  return pimpl->models_;
}
