#ifndef QRK_DEVICE_MANAGER_H
#define QRK_DEVICE_MANAGER_H

/*!
  \file
  \brief デバイス管理

  \author Satofumi KAMIMURA

  $Id: DeviceManager.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <luabind/luabind.hpp>


namespace qrk
{
  class Device;
  class OdeModel;


  //! デバイスの管理クラス
  class DeviceManager
  {
  public:
    DeviceManager(void);
    ~DeviceManager(void);

    void terminate(void);

    long nextPort(void);
    void registerDevicePort(const char* device, long port);
    long port(const char* device) const;


    void createDevice(const char* device_name, const char* class_name,
                      const char* alias);
    void createEvent(const luabind::object& function, const char* alias);
    void removeEvent(const char* alias);

    void setType(const char* type, const char* parameter);

    Device* device(const char* alias);
    OdeModel* model(const char* alias);

  private:
    DeviceManager(const DeviceManager& rhs);
    DeviceManager& operator = (const DeviceManager& rhs);

    struct pImpl;
    pImpl* pimpl;
  };
}

#endif /* !QRK_DEVICE_MANAGER_H */
