#ifndef QRK_CYLINDER_H
#define QRK_CYLINDER_H

/*!
  \file
  \brief シミュレーション用の障害物(Cylinder)

  \author Satofumi KAMIMURA

  $Id: Cylinder.h 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "OdeModel.h"
#include <memory>


namespace qrk
{
  class Color;


  class Cylinder : public OdeModel
  {
    Cylinder(void);
    Cylinder(const Cylinder& rhs);
    Cylinder& operator = (const Cylinder& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    Cylinder(long radius, long length, dReal mass = 1.0);
    ~Cylinder(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void);

    void setPosition3d(const Point3d<long>& position,
                       double ax, double ay, double az,
                       const Angle& angle,
                       OdeModel* model = NULL, bool fixed = true);

    void position3d(long& px, long& py, long& pz,
                    double& dx, double& dy, double& dz);

    void setColor(const Color& color);

    dBodyID objectId(void) const;
  };
}

#endif /* !QRK_CYLINDER_H */
