#ifndef QRK_DETECT_FEATURE_POINTS_H
#define QRK_DETECT_FEATURE_POINTS_H

/*!
  \file
  \brief 特徴点、線分の抽出

  \author Satofumi KAMIMURA

  $Id: detectFeaturePoints.h 1450 2009-10-25 21:15:53Z satofumi $
*/

#include "Position.h"
#include "distance_t.h"
#include "segment_t.h"
#include "featurePoint_t.h"


//! Quick Robot Development Kit
namespace qrk
{
  class RangeFinder;


  /*!
    \brief 特徴点の検出

    \param[out] feature_points 特徴点
    \param[out] segments 線分
    \param[in] position 測定時のレーザレンジセンサ位置
    \param[in] lrf レーザレンジセンサ
    \param[in] data 測定データ
    \param[in] distance 部分的な距離データ
    \param[in] range データの幅
  */
  void detectFeaturePoints(std::vector<featurePoint_t>& feature_points,
                           std::vector<segment_t>& segments,
                           const Position<long>& position,
                           const RangeFinder& lrf,
                           const std::vector<long>& data,
                           const distance_t& distance,
                           const range_t& range);
}

#endif /* !QRK_DETECT_FEATURE_POINTS_H */
