/*!
  \file
  \brief 接続の関数

  \author Satofumi KAMIMURA

  $Id: connectDevice.cpp 1573 2009-12-07 23:14:05Z satofumi $
*/

#include "connectDevice.h"
#include "BeegoDrive.h"
#include "mBeegoDrive.h"
#include "mUrgDevice.h"

using namespace qrk;
using namespace std;


bool qrk::connectDevice(BeegoDrive& run, const char* device, long baudrate)
{
  if (! run.connect(device, baudrate)) {
    cout << "BeegoDrive::connect: " << run.what() << endl;
    return false;
  }
  return true;
}


bool qrk::connectDevice(UrgDevice& urg, const char* device, long baudrate)
{
  if (! urg.connect(device, baudrate)) {
    cout << "urgDevice::connect: " << urg.what() << endl;
    return false;
  }
  return true;
}


bool qrk::connectDevice(mBeegoDrive& run, const char* device, long baudrate)
{
  if (! run.connect(device, baudrate)) {
    cout << "mBeegoDrive::connect: " << run.what() << endl;
    return false;
  }
  return true;
}


bool qrk::connectDevice(mUrgDevice& urg, const char* device, long baudrate)
{
  if (! urg.connect(device, baudrate)) {
    cout << "murgDevice::connect: " << urg.what() << endl;
    return false;
  }
  return true;
}
