#ifndef QRK_MANAGED_TICKS_H
#define QRK_MANAGED_TICKS_H

/*!
  \file
  \brief 時間経過の管理クラス

  \author Satofumi KAMIMURA

  $Id: ManagedTicks.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <memory>


namespace qrk
{
    //! 時間経過の管理クラス
    class ManagedTicks
    {
    public:
        typedef long (*TicksFunction)(void);

        ManagedTicks(void);
        ~ManagedTicks(void);

        void setTicksFunction(TicksFunction function);

        long ticks(void) const;

        // !!! 速度率の最大、最小を定義できるようにする

        void play(void);
        void pause(void);
        void resume(void);
        void moreFaster(void);
        void moreSlower(void);

    private:
        ManagedTicks(const ManagedTicks& rhs);
        ManagedTicks& operator = (const ManagedTicks& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_MANAGED_TICKS_H */
