#ifndef COMMAND_PACKET_H
#define COMMAND_PACKET_H

/*!
  \file
  \brief コマンドの送受信

  \author Satofumi KAMIMURA

  $Id: CommandPacket.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "system_t.h"
#include <memory>


namespace qrk
{
  class Connection;


  //! 走行制御用の送受信コマンド
  class CommandPacket
  {
  public:
    CommandPacket(void);
    ~CommandPacket(void);

    void setConnection(Connection* connection);

    // !!! timeout の変更メソッド

    bool version(unsigned char* major,
                 unsigned char* minor, unsigned char* micro);

    bool isStable(bool& stable);

    bool position(long mm[], unsigned short* dir16);

    bool stop(void);

    bool setWheelVelocity(int id, long mm_per_sec);

    bool setStraightVelocity(long mm_per_sec);

    bool straightVelocity(long* mm_per_sec);

    bool maxStraightVelocity(long* mm_per_sec);

    bool setRotateVelocity(long dir16);

    bool rotateVelocity(long* dir16);

    bool followLine(long x, long y, unsigned short dir16);

    bool stopLine(long x, long y, unsigned short dir16);

    bool spin(long dir16);
    bool rotate(long dir16);

    bool followCircle(long x, long y, long radius);

    // !!!

  private:
    CommandPacket(const CommandPacket& rhs);
    CommandPacket& operator = (const CommandPacket& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !COMMAND_PACKET_H */
