#ifndef QRK_CAMERA_H
#define QRK_CAMERA_H

/*!
  \file
  \brief カメラデバイス

  \author Satofumi KAMIMURA

  $Id: Camera.h 1414 2009-10-14 23:14:02Z satofumi $
*/

namespace qrk
{
  class Camera
  {
  public:
    virtual ~Camera(void)
    {
    }

    virtual const char* what(void) const = 0;

    virtual bool connect(void) = 0;
    virtual void disconnect(void) = 0;

    virtual void setCaptureSize(int width, int height) = 0;
    virtual bool capture(const char* file_name) = 0;
  };
}

#endif /* !QRK_CAMERA_H */
