#ifndef QRK_PACKET_UTILS_H
#define QRK_PACKET_UTILS_H

/*!
  \file
  \brief パケット処理の補助

  \author Satofumi KAMIMURA

  $Id: PacketUtils.h 924 2009-05-24 14:03:08Z satofumi $
*/

#include "Packet.h"
#include <string>


namespace qrk
{
  //! Type までのパケットを作成する。Length はダミーデータで埋める
  void createPacketHeader(Packet& packet, const char* type);

  void setPacketLength(Packet& packet);
  size_t packetLength(const Packet& packet);

  std::string packetType(const Packet& packet);

  void addParameter(Packet& packet, const char* text);
  void addParameter(Packet& packet, size_t value, size_t byte = 4);
  void addParameter(Packet& packet, ClientId value);

  size_t parameter(const char* packet_data, size_t byte);

  void dumpPacket(const Packet& packet);
}

#endif /* !QRK_PACKET_UTILS_H */
