/*!
  \file
  \brief SDL システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlInit.cpp 453 2009-01-06 12:21:24Z satofumi $
*/

#include <cstdlib>
#include "SdlInit.h"
#include <SDL.h>

using namespace qrk;


struct SdlInit::pImpl
{
  static bool initialized_;
};
bool SdlInit::pImpl::initialized_ = false;


SdlInit::SdlInit(void) : pimpl(new pImpl)
{
  if (pimpl->initialized_) {
    // 初期化済みならば、戻る
    return;
  }

  if (SDL_Init(0) < 0) {
    // !!! 例外を投げるべき
    return;
  }
  atexit(SDL_Quit);
  pimpl->initialized_ = true;
}


SdlInit::~SdlInit(void)
{
}
