#ifndef QRK_M_CAMERA_CTRL_H
#define QRK_M_CAMERA_CTRL_H

/*!
  \file
  \brief モニタ対応のカメラ制御

  \author Satofumi KAMIMURA

  $Id: mCameraDevice.h 1411 2009-10-14 21:13:36Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief モニタ対応のカメラ制御
  */
  class mCameraDevice
  {
    mCameraDevice(void);
    mCameraDevice(const mCameraDevice& rhs);
    mCameraDevice& operator = (const mCameraDevice& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    mCameraDevice(int argc, char *argv[]);
    ~mCameraDevice(void);

    const char* what(void);

    bool connect(void);
    void disconnect(void);

    void setCaptureSize(int width, int height);
    bool capture(const char* fileName = "capture.jpg");
  };
}

#endif /* !QRK_M_CAMERA_CTRL_H */
