-- scheduler.lua の動作サンプル
-- Satofumi KAMIMURA
-- $Id: scheduler_sample.lua 702 2009-04-01 19:37:33Z satofumi $

require("Scheduler")


-- 1 から 4 まで表示する
function print4()

   for i = 1, 4 do
      print("<" .. '0' + i .. ">")
      Scheduler:yield()
   end
   Scheduler:yield()
end


-- 1 から 2 まで表示する
function print2()

   for i = 1, 2 do
      print("[" .. '0' + i .. "]")
      Scheduler:yield()
   end
end


-- ２つのコルーチンを登録する
local scheduler = Scheduler:new()

scheduler:insert(print4)
scheduler:insert(print2)


local index = 1
for i = 1, 6 do
   print("--- " .. index .. " [times] ---")
   index = index + 1
   scheduler:execute()
end


-- コルーチン再利用の動作確認
scheduler:insert(print2)

for i = 1, 3 do
   print("--- " .. index .. " [times] ---")
   index = index + 1
   scheduler:execute()
end
