-- 部分的に Lua スクリプトを利用するサンプル
-- Satofumi KAMIMURA
-- $Id: partial.lua 808 2009-05-06 21:40:00Z satofumi $

require("Scheduler")


-- 初期化を行う
-- この処理は、Lua スクリプトを読み出したときに実行される
local id_ = 0


-- 関数が呼び出される毎に実行したい処理を、コルーチンで実装しておく
-- コルーチンを使っているのは、中断と再開を行わせたいため
-- 今回の実装ならば、(while を削除すれば) C++ から lua_function() を
-- 直接呼び出す実装でよい
function lua_function()
   while true do
      print("Lua: " .. id_)
      id_ = id_ + 1
      Scheduler:yield()
   end
end

local scheduler = Scheduler:new()
scheduler:insert(lua_function)


-- コルーチンを処理するように記述しておき、
-- C++ からこの関数を呼び出す
function lua_function()
   scheduler:execute()
end