/*!
  \exampl callFunction.cpp
  \brief Lua 関数の呼び出しサンプル

  \author Satofumi KAMIMURA

  $Id: callFunction.cpp 1487 2009-11-02 07:54:23Z satofumi $
*/

#include <luabind/luabind.hpp>
#include <lua.hpp>
#include <iostream>

using namespace luabind;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  // Lua, Luabind の初期化
  lua_State* lua = lua_open();
  luaL_openlibs(lua);
  luabind::open(lua);

  // Lua スクリプトのロード
  if (luaL_dofile(lua, "hello_function.lua")) {
    string error_message = lua_tostring(lua, -1);
    cout << "loadL_dofile: " << error_message << endl;
    exit(1);
  }

  try {
    call_function<void>(lua, "hello");

  } catch (const error &e) {
    static_cast<void>(e);
    cout << "hello(): " << lua_tostring(lua, -1) << endl;
  }

  return 0;
}
