/*!
  \file
  \brief Lua への system モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindSystem.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "luabindSystem.h"
#include "delay.h"
#include "ticks.h"
#include "CycleTimer.h"
#include "StopWatch.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindSystem(lua_State* L)
{
    module(L)
        [
         def("delay", &delay),
         def("ticks", &ticks),

         class_<CycleTimer>("CycleTimer")
         .def(constructor<>())
         .def("waitMsec", &CycleTimer::waitMsec)
         .def("reset", &CycleTimer::reset)
         .def("setStrictCycle", &CycleTimer::setStrictCycle)
         .def("setCycleFps", &CycleTimer::setCycleFps)
         .def("cycleFps", &CycleTimer::cycleFps)
         .def("setCycleMsec", &CycleTimer::setCycleMsec)
         .def("cycleMsec", &CycleTimer::cycleMsec)
         .def("toNextCycleMsec", &CycleTimer::toNextCycleMsec),

         class_<StopWatch>("StopWatch")
         .def(constructor<>())
         .def("start", &StopWatch::start)
         .def("ticks", &StopWatch::ticks)
         .def("stop", &StopWatch::stop)
         ];
}
