/*!
  \file
  \brief Lua への input モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindInput.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "luabindInput.h"
#include "convertToRoman.h"
#include "convertToJp.h"
#include "Utf8.h"
#include "utf8_string.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindInput(lua_State* L)
{
    module(L)
        [
         class_<Utf8>("Utf8")
         .def(constructor<const char*>())
         .def("size", &Utf8::size)
         .def("ch", &Utf8::ch)
         .def("toStdString", &Utf8::toStdString)
         .def("substr", &Utf8::substr)
         .def("pop_back", &Utf8::pop_back),

         def("convertToRoman", &convertToRoman),
         def("convertToJp", &convertToJp),

         def("utf8_matchSize", &utf8_matchSize)
         ];
}
