/*!
  \file
  \brief Lua への gui モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindGui.cpp 1957 2011-07-27 23:13:30Z satofumi $
*/

#include "luabindGui.h"
#include "LuaHandler.h"
#include "Screen.h"
#include "TextInput.h"
#include "EventUtils.h"
#include "LayerManager.h"
#include "Layer.h"
#include "Font.h"
#include "TextSurface.h"
#include "TextFadeSurface.h"
#include "TextRubiFadeSurface.h"
#include "ColorSurface.h"
#include "FillSurface.h"
#include "ImageSurface.h"
#include "CanvasSurface.h"
#include "MultiSurface.h"
#include "Label.h"
#include "Button.h"
#include "Menu.h"
#include "ChatMessage.h"
#include "CallbackEvent.h"
#include "AlignUtils.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindGui(lua_State* L)
{
    module(L)
        [
         class_<Screen>("Screen")
         .def(constructor<>())
         .def("rect", &Screen::rect)
         .def("setFullscreen", &Screen::setFullscreen)
         .def("isFullscreen", &Screen::isFullscreen)
         .def("toggleScreen", &Screen::toggleScreen)
         .def("showCursor", &Screen::showCursor)
         .def("isShowCursor", &Screen::isShowCursor)
         .def("setClearColor", &Screen::setClearColor)
         .def("clear", &Screen::clear),

         def("Screen_enter2D", &Screen::enter2D),
         def("Screen_leave2D", &Screen::leave2D),

         class_<Event>("Event"),

         class_<CallbackEvent, Event>("CallbackEvent")
         .def(constructor<>())
         .def("setEventAcceptable", &CallbackEvent::setEventAcceptable)
         .def("clearEvent", &CallbackEvent::clearEvent)
         .def("key", &CallbackEvent::key)
         .def("click", &CallbackEvent::click)
         .def("enterCursor", &CallbackEvent::enterCursor)
         .def("moveCursor", &CallbackEvent::moveCursor)
         .def("setActive", &CallbackEvent::setActive)
         .def("isActive", &CallbackEvent::isActive)
         .def("setCallback", &CallbackEvent::setCallback),

         class_<TextInput, Event>("TextInput")
         .def(constructor<>())
         .def("clear", &TextInput::clear)
         .def("empty", &TextInput::empty)
         .def("text", &TextInput::text)
         .def("isChanged", &TextInput::isChanged)
         .def("setBackspaceEvent", &TextInput::setBackspaceEvent)
         .def("setDecideEvent", &TextInput::setDecideEvent),

         def("setQuitEvent", &setQuitEvent),
         def("setEnterEvent", &setEnterEvent),

         class_<LayerManager>("LayerManager")
         .def(constructor<>())
         .def("updateEvent", &LayerManager::updateEvent)
         .def("draw", &LayerManager::draw)
         .def("swap", &LayerManager::swap)
         .def("clearEvent", &LayerManager::clearEvent)
         .def("insertEvent", &LayerManager::insertEvent)
         .def("removeEvent", &LayerManager::removeEvent)
         .def("clear", &LayerManager::clear)
         .def("push_front", &LayerManager::push_front)
         .def("push_back", &LayerManager::push_back)
         .def("remove", &LayerManager::remove),

         class_<LayerInterface>("LayerInterface"),

         class_<Layer, LayerInterface>("Layer")
         .def(constructor<>())
         .def("clear", &Layer::clear)
         .def("push_front", &Layer::push_front)
         .def("push_back", &Layer::push_back)
         .def("remove", &Layer::remove)
         .def("setAlpha", &Layer::setAlpha)
         .def("alpha", &Layer::alpha)
         .def("draw", &Layer::draw),

         class_<Font>("Font")
         .def(constructor<const char*, size_t, bool>())
         .def("duplicate", &Font::duplicate)
         .def("isValid", &Font::isValid)
         .def("setPixelSize", &Font::setPixelSize)
         .def("pixelSize", &Font::pixelSize)
         .def("setForegroundColor", &Font::setForegroundColor)
         .def("foregroundColor", &Font::foregroundColor)
         .def("setBackgroundColor", &Font::setBackgroundColor)
         .def("backgroundColor", &Font::backgroundColor)
         .def("setTransparent", &Font::setTransparent)
         .def("transparent", &Font::transparent),

         class_<Surface>("Surface"),

         class_<TextSurface, Surface>("TextSurface")
         .def(constructor<const Font&, const char*>())
         .def("rect", &TextSurface::rect)
         .def("setAlpha", &TextSurface::setAlpha)
         .def("draw", &TextSurface::draw),

         class_<TextFadeSurface, Surface>("TextFadeSurface")
         .def(constructor<const Font&, const char*>())
         .def("rect", &TextFadeSurface::rect)
         .def("setAlpha", &TextFadeSurface::setAlpha)
         .def("draw", &TextFadeSurface::draw)
         .def("setFadePercent", &TextFadeSurface::setFadePercent),

         class_<TextRubiFadeSurface, Surface>("TextRubiFadeSurface")
         .def(constructor<const Font&, const char*, const Font&, const char*>())
         .def("rect", &TextRubiFadeSurface::rect)
         .def("setAlpha", &TextRubiFadeSurface::setAlpha)
         .def("draw", &TextRubiFadeSurface::draw)
         .def("setFadePercent", &TextRubiFadeSurface::setFadePercent),

         class_<ColorSurface, Surface>("ColorSurface")
         .def(constructor<const Rect<long>&, const Color&>())
         .def("rect", &ColorSurface::rect)
         .def("setAlpha", &ColorSurface::setAlpha)
         .def("draw", &ColorSurface::draw),

         class_<FillSurface, Surface>("FillSurface")
         .def(constructor<const Rect<long>&, Surface&>())
         .def("rect", &FillSurface::rect)
         .def("setAlpha", &FillSurface::setAlpha)
         .def("draw", &FillSurface::draw),

         class_<ImageSurface, Surface>("ImageSurface")
         .def(constructor<const char*, bool>())
         .def("isValid", &ImageSurface::isValid)
         .def("rect", &ImageSurface::rect)
         .def("setAlpha", &ImageSurface::setAlpha)
         .def("draw", &ImageSurface::draw),

         class_<CanvasSurface, Surface>("CanvasSurface")
         .def(constructor<const Rect<long>&>())
         .def("isValid", &CanvasSurface::isValid)
         .def("rect", &CanvasSurface::rect)
         .def("setAlpha", &CanvasSurface::setAlpha)
         .def("draw", &CanvasSurface::draw)
         .def("setFont", &CanvasSurface::setFont)
         .def("setClearColor", &CanvasSurface::setClearColor)
         .def("clear", &CanvasSurface::clear)
         .def("setColor", &CanvasSurface::setColor)
         .def("setLineWidth", &CanvasSurface::setLineWidth)
         .def("drawLineStrip", &CanvasSurface::drawLineStrip)
         .def("drawCircle", &CanvasSurface::drawCircle)
         .def("drawQuadStrip", &CanvasSurface::drawQuadStrip)
         .def("drawText", &CanvasSurface::drawText),

         class_<MultiSurface, Surface>("MultiSurface")
         .def(constructor<Surface&>())
         .def("rect", &MultiSurface::rect)
         .def("setAlpha", &MultiSurface::setAlpha)
         .def("draw", &MultiSurface::draw)
         .def("push_front", &MultiSurface::push_front),

         class_<Component>("Component"),

         class_<Label, Component>("Label")
         .def(constructor<Surface&>())
         .def("setPosition", &Label::setPosition)
         .def("position", &Label::position)
         .def("rect", &Label::rect)
         .def("setAlpha", &Label::setAlpha),

         class_<Button, Component>("Button")
         .def(constructor<Surface&, Surface&, Surface&>()),

         class_<Menu, Component>("Menu")
         .enum_("Align")
         [
          value("Left", Menu::Left),
          value("Center", Menu::Center),
          value("Right", Menu::Right),
          value("Top", Menu::Top),
          value("Middle", Menu::Middle),
          value("Bottom", Menu::Bottom)
          ]
         .enum_("Axis")
         [
          value("Verbatim", Menu::Verbatim),
          value("Horizontal", Menu::Horizontal)
          ]
         .def(constructor<const Rect<long>&, int, Menu::Axis>())
         .def("setEventAcceptable", &Menu::setEventAcceptable)
         .def("setAlpha", &Menu::setAlpha)
         .def("alpha", &Menu::alpha)
         .def("setPosition", &Menu::setPosition)
         .def("setButtonStep", &Menu::setButtonStep)
         .def("addButton", &Menu::addButton)
         .def("setEnableNoSelect", &Menu::setEnableNoSelect)
         .def("setEnableRotate", &Menu::setEnableRotate)
         .def("setEnableClickedAndFocus", &Menu::setEnableClickedAndFocus)
         .def("indexSize", &Menu::indexSize)
         .def("setIndex", &Menu::setIndex)
         .def("press", &Menu::press)
         .def("release", (void(Menu::*)(void))&Menu::release)
         .def("index", &Menu::index)
         .def("isClicked", &Menu::isClicked)
         .def("clickedId", &Menu::clickedId)
         .def("clickedIndex", &Menu::clickedIndex)
         .def("registerIconLabel", &Menu::registerIconLabel)
         .def("unregisterIconLabel", &Menu::unregisterIconLabel)
         .def("setIconOffset", &Menu::setIconOffset)
         .def("connectPressedEvent", &Menu::connectPressedEvent),

         class_<ChatMessage, Component>("ChatMessage")
         .def(constructor<Font&, const Rect<long>&>())
         .def("setPosition", &ChatMessage::setPosition)
         .def("position", &ChatMessage::position)
         .def("setDrawTimeout", &ChatMessage::setDrawTimeout)
         .def("setFadeoutTime", &ChatMessage::setFadeoutTime)
         .def("setOffset", &ChatMessage::setOffset)
         .def("clear", &ChatMessage::clear)
         .def("print", &ChatMessage::print)
         .def("newline", &ChatMessage::newline),

         def("left", (long(*)(const Component&, long))&left),
         def("center", (long(*)(const Component&, long))&center),
         def("right", (long(*)(const Component&, long))&right),
         def("top", (long(*)(const Component&, long))&top),
         def("middle", (long(*)(const Component&, long))&middle),
         def("bottom", (long(*)(const Component&, long))&bottom),

         def("left", (long(*)(const Surface&, long))&left),
         def("center", (long(*)(const Surface&, long))&center),
         def("right", (long(*)(const Surface&, long))&right),
         def("top", (long(*)(const Surface&, long))&top),
         def("middle", (long(*)(const Surface&, long))&middle),
         def("bottom", (long(*)(const Surface&, long))&bottom)
         ];

    LuaHandler::registerValue(L, "SDLK_BACKSPACE", SDLK_BACKSPACE);
    LuaHandler::registerValue(L, "SDLK_ESCAPE", SDLK_ESCAPE);
    LuaHandler::registerValue(L, "SDLK_RETURN", SDLK_RETURN);
    LuaHandler::registerValue(L, "SDLK_F4", SDLK_F4);
    LuaHandler::registerValue(L, "SDLK_LEFT", SDLK_LEFT);
    LuaHandler::registerValue(L, "SDLK_RIGHT", SDLK_RIGHT);

    LuaHandler::registerValue(L, "SDLK_a", SDLK_a);
    LuaHandler::registerValue(L, "SDLK_b", SDLK_b);
    LuaHandler::registerValue(L, "SDLK_c", SDLK_c);
    LuaHandler::registerValue(L, "SDLK_d", SDLK_d);
    LuaHandler::registerValue(L, "SDLK_e", SDLK_e);
    LuaHandler::registerValue(L, "SDLK_f", SDLK_f);
    LuaHandler::registerValue(L, "SDLK_g", SDLK_g);
    LuaHandler::registerValue(L, "SDLK_h", SDLK_h);
    LuaHandler::registerValue(L, "SDLK_i", SDLK_i);
    LuaHandler::registerValue(L, "SDLK_j", SDLK_j);
    LuaHandler::registerValue(L, "SDLK_k", SDLK_k);
    LuaHandler::registerValue(L, "SDLK_l", SDLK_l);
    LuaHandler::registerValue(L, "SDLK_m", SDLK_m);
    LuaHandler::registerValue(L, "SDLK_n", SDLK_n);
    LuaHandler::registerValue(L, "SDLK_o", SDLK_o);
    LuaHandler::registerValue(L, "SDLK_p", SDLK_p);
    LuaHandler::registerValue(L, "SDLK_q", SDLK_q);
    LuaHandler::registerValue(L, "SDLK_r", SDLK_r);
    LuaHandler::registerValue(L, "SDLK_s", SDLK_s);
    LuaHandler::registerValue(L, "SDLK_t", SDLK_t);
    LuaHandler::registerValue(L, "SDLK_u", SDLK_u);
    LuaHandler::registerValue(L, "SDLK_v", SDLK_v);
    LuaHandler::registerValue(L, "SDLK_w", SDLK_w);
    LuaHandler::registerValue(L, "SDLK_x", SDLK_x);
    LuaHandler::registerValue(L, "SDLK_y", SDLK_y);
    LuaHandler::registerValue(L, "SDLK_z", SDLK_z);

    LuaHandler::registerValue(L, "SDL_KEYDOWN", SDL_KEYDOWN);
    LuaHandler::registerValue(L, "SDL_KEYUP", SDL_KEYUP);

    LuaHandler::registerValue(L, "KMOD_NONE", KMOD_NONE);
    LuaHandler::registerValue(L, "KMOD_LCTRL", KMOD_LCTRL);
    LuaHandler::registerValue(L, "KMOD_RCTRL", KMOD_RCTRL);
    LuaHandler::registerValue(L, "KMOD_LALT", KMOD_LALT);
    LuaHandler::registerValue(L, "KMOD_RALT", KMOD_RALT);

    LuaHandler::registerValue(L, "SDL_BUTTON_LEFT", SDL_BUTTON_LEFT);
    LuaHandler::registerValue(L, "SDL_MOUSEBUTTONDOWN", SDL_MOUSEBUTTONDOWN);
}
