/*!
  \file
  \brief Lua への common モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindCommon.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "luabindCommon.h"
#include "Color.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindCommon(lua_State* L)
{
    module(L)
        [
         class_<Color>("Color")
         .def(constructor<float, float, float, float>())
         .def_readwrite("r", &Color::r)
         .def_readwrite("g", &Color::g)
         .def_readwrite("b", &Color::b)
         .def_readwrite("a", &Color::a)
         ];
}
