/*!
  \file
  \brief Lua への AUDIO モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindAudio.cpp 1967 2011-10-14 06:29:53Z satofumi $
*/

#include "luabindAudio.h"
#include "LuaHandler.h"
#include "Audio.h"
#include "BackMusic.h"
#include "SoundEffect.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindAudio(lua_State* L)
{
    module(L)
        [
         class_<Audio>("Audio")
         .def(constructor<>())
         .def("what", &Audio::what)
         .def("initialize", &Audio::initialize)
         .def("isInitialized", &Audio::isInitialized),

         class_<BackMusic>("BackMusic")
         .def(constructor<>())
         .def("setMute", &BackMusic::setMute)
         .def("isMute", &BackMusic::isMute)
         .def("setVolume", &BackMusic::setVolume)
         .def("play", &BackMusic::play)
         .def("stop", &BackMusic::stop)
         .def("isPlaying", &BackMusic::isPlaying),

         class_<SoundEffect>("SoundEffect")
         .def(constructor<const char*>())
         .def("setMute", &SoundEffect::setMute)
         .def("isMute", &SoundEffect::isMute)
         .def("setMasterVolume", &SoundEffect::setMasterVolume)
         .def("setVolume", &SoundEffect::setVolume)
         .def("play", &SoundEffect::play)
         .def("stop", &SoundEffect::stop)
         .def("updatePosition", &SoundEffect::updatePosition)
         .def("isPlaying", &SoundEffect::isPlaying)
         ];

    LuaHandler::registerValue(L, "BackMusic_Instantly", BackMusic::Instantly);
    LuaHandler::registerValue(L, "BackMusic_Infinity", BackMusic::Infinity);
}
