#!/usr/bin/ruby
# -*- coding: utf-8 -*-

# txt 形式のかな変換テーブルを C/C++ のヘッダファイルに変換する
# Satofumi KAMIMURA
# $Id: table_converter.rb 1823 2010-05-11 22:11:47Z satofumi $

require 'kconv'
require 'jcode'
$KCODE = 'UTF-8'

$maxPattern_size = 0


# 変換処理
def convertLine(line)
  out = ''

  if /([^ ]+) (.+)/ =~ line
    before = Regexp.last_match[1]
    after = Regexp.last_match[2]

    if before.jlength > $maxPattern_size
      $maxPattern_size = before.jlength
    end
    if after.jlength > $maxPattern_size
      $maxPattern_size = after.jlength
    end

    # 変換元の文字列の出力
    out = '        { { '
    pre_ch = ''
    before.each_char { |ch|
      # 文字がマルチバイト文字の場合
      if ch.mbchar?
        out += '0x'
        out += ('0' + ch[2].to_s(16))[-2, 2]
        out += ('0' + ch[1].to_s(16))[-2, 2]
        out += ('0' + ch[0].to_s(16))[-2, 2]
        out += ', '
      else
      if pre_ch == '\\'
        out += "'\\" + ch + "',"
      elsif ch != '\\'
        out += "'" + ch + "',"
      end
        pre_ch = ch
      end
    }
    out += ' 0x00 }, { '

    # 変換後の文字列の出力
    after.each_char { |wch|
      out += '0x'
      if Kconv.guess(wch) != Kconv::ASCII then
        out += ('0' + wch[0].to_s(16))[-2, 2]
        out += ('0' + wch[1].to_s(16))[-2, 2]
        out += ('0' + wch[2].to_s(16))[-2, 2]
      else
        out += ('0' + wch[0].to_s(16))[-2, 2]
      end
      out += ', '
    }
    out += '0x00 },'

    # コメントとして変換後の文字を表示
    out += " }, // " + after + "\n"
  end
  return out
end


# 変換元ファイル
fileName = ARGV[0]

# 行毎に変換
converted_lines = ''
open (fileName) { |io|
  while line = io.gets
    converted_lines += convertLine(line)
  end
}

/(.+)_table.txt/ =~ fileName
typeName = Regexp.last_match[1].capitalize
capitalizedTypeName = typeName.upcase
$maxPattern_size += 1

# 変換結果の出力
print <<-EOB
#ifndef #{capitalizedTypeName}_CONVERT_TBL_H
#define #{capitalizedTypeName}_CONVERT_TBL_H

/*!
  \\file
  \\brief ローマ字・かな変換テーブル(自動生成)

  \\author Satofumi KAMIMURA

  $Id: table_converter.rb 1823 2010-05-11 22:11:47Z satofumi $
*/


namespace qrk {
    enum { #{capitalizedTypeName}_CONVERT_SIZE_MAX = #{$maxPattern_size} };

    //! #{typeName} 変換用の Unicode 配列
    const static unsigned long #{typeName}Table[][2][#{$maxPattern_size}] = {
#{converted_lines}        { { 0x00 }, { 0x00 }, }, // テーブルの終端
    };
};

#endif /* !#{capitalizedTypeName}_CONVERT_TBL_H */
EOB
