#ifndef ROMAN_CONVERT_TBL_H
#define ROMAN_CONVERT_TBL_H

/*!
  \file
  \brief ローマ字・かな変換テーブル(自動生成)

  \author Satofumi KAMIMURA

  $Id: roman_table.h 1823 2010-05-11 22:11:47Z satofumi $
*/


namespace qrk {
    enum { ROMAN_CONVERT_SIZE_MAX = 5 };

    //! Roman 変換用の Unicode 配列
    const static unsigned long RomanTable[][2][5] = {
        { { 'a', 0x00 }, { 0xe38182, 0x00 }, }, // あ
        { { 'i', 0x00 }, { 0xe38184, 0x00 }, }, // い
        { { 'u', 0x00 }, { 0xe38186, 0x00 }, }, // う
        { { 'e', 0x00 }, { 0xe38188, 0x00 }, }, // え
        { { 'o', 0x00 }, { 0xe3818a, 0x00 }, }, // お
        { { 'k','y','a', 0x00 }, { 0xe3818d, 0xe38283, 0x00 }, }, // きゃ
        { { 'k','y','i', 0x00 }, { 0xe3818d, 0xe38183, 0x00 }, }, // きぃ
        { { 'k','y','u', 0x00 }, { 0xe3818d, 0xe38285, 0x00 }, }, // きゅ
        { { 'k','y','e', 0x00 }, { 0xe3818d, 0xe38187, 0x00 }, }, // きぇ
        { { 'k','y','o', 0x00 }, { 0xe3818d, 0xe38287, 0x00 }, }, // きょ
        { { 'k','w','a', 0x00 }, { 0xe3818f, 0xe38181, 0x00 }, }, // くぁ
        { { 'k','a', 0x00 }, { 0xe3818b, 0x00 }, }, // か
        { { 'k','i', 0x00 }, { 0xe3818d, 0x00 }, }, // き
        { { 'k','u', 0x00 }, { 0xe3818f, 0x00 }, }, // く
        { { 'k','e', 0x00 }, { 0xe38191, 0x00 }, }, // け
        { { 'k','o', 0x00 }, { 0xe38193, 0x00 }, }, // こ
        { { 's','y','a', 0x00 }, { 0xe38197, 0xe38283, 0x00 }, }, // しゃ
        { { 's','h','a', 0x00 }, { 0xe38197, 0xe38283, 0x00 }, }, // しゃ
        { { 's','y','i', 0x00 }, { 0xe38197, 0xe38183, 0x00 }, }, // しぃ
        { { 's','y','u', 0x00 }, { 0xe38197, 0xe38285, 0x00 }, }, // しゅ
        { { 's','h','u', 0x00 }, { 0xe38197, 0xe38285, 0x00 }, }, // しゅ
        { { 's','y','e', 0x00 }, { 0xe38197, 0xe38187, 0x00 }, }, // しぇ
        { { 's','h','e', 0x00 }, { 0xe38197, 0xe38187, 0x00 }, }, // しぇ
        { { 's','y','o', 0x00 }, { 0xe38197, 0xe38287, 0x00 }, }, // しょ
        { { 's','h','o', 0x00 }, { 0xe38197, 0xe38287, 0x00 }, }, // しょ
        { { 's','a', 0x00 }, { 0xe38195, 0x00 }, }, // さ
        { { 's','i', 0x00 }, { 0xe38197, 0x00 }, }, // し
        { { 's','h','i', 0x00 }, { 0xe38197, 0x00 }, }, // し
        { { 's','u', 0x00 }, { 0xe38199, 0x00 }, }, // す
        { { 's','e', 0x00 }, { 0xe3819b, 0x00 }, }, // せ
        { { 's','o', 0x00 }, { 0xe3819d, 0x00 }, }, // そ
        { { 't','s','a', 0x00 }, { 0xe381a4, 0xe38181, 0x00 }, }, // つぁ
        { { 't','s','i', 0x00 }, { 0xe381a4, 0xe38183, 0x00 }, }, // つぃ
        { { 't','s','e', 0x00 }, { 0xe381a4, 0xe38187, 0x00 }, }, // つぇ
        { { 't','s','o', 0x00 }, { 0xe381a4, 0xe38189, 0x00 }, }, // つぉ
        { { 't','h','a', 0x00 }, { 0xe381a6, 0xe38283, 0x00 }, }, // てゃ
        { { 't','h','i', 0x00 }, { 0xe381a6, 0xe38183, 0x00 }, }, // てぃ
        { { 't','h','u', 0x00 }, { 0xe381a6, 0xe38285, 0x00 }, }, // てゅ
        { { 't','h','e', 0x00 }, { 0xe381a6, 0xe38187, 0x00 }, }, // てぇ
        { { 't','h','o', 0x00 }, { 0xe381a6, 0xe38287, 0x00 }, }, // てょ
        { { 't','y','a', 0x00 }, { 0xe381a1, 0xe38283, 0x00 }, }, // ちゃ
        { { 'c','y','a', 0x00 }, { 0xe381a1, 0xe38283, 0x00 }, }, // ちゃ
        { { 'c','h','a', 0x00 }, { 0xe381a1, 0xe38283, 0x00 }, }, // ちゃ
        { { 't','y','i', 0x00 }, { 0xe381a1, 0xe38183, 0x00 }, }, // ちぃ
        { { 'c','y','i', 0x00 }, { 0xe381a1, 0xe38183, 0x00 }, }, // ちぃ
        { { 't','y','u', 0x00 }, { 0xe381a1, 0xe38285, 0x00 }, }, // ちゅ
        { { 'c','y','u', 0x00 }, { 0xe381a1, 0xe38285, 0x00 }, }, // ちゅ
        { { 'c','h','u', 0x00 }, { 0xe381a1, 0xe38285, 0x00 }, }, // ちゅ
        { { 't','y','e', 0x00 }, { 0xe381a1, 0xe38187, 0x00 }, }, // ちぇ
        { { 'c','y','e', 0x00 }, { 0xe381a1, 0xe38187, 0x00 }, }, // ちぇ
        { { 'c','h','e', 0x00 }, { 0xe381a1, 0xe38187, 0x00 }, }, // ちぇ
        { { 't','y','o', 0x00 }, { 0xe381a1, 0xe38287, 0x00 }, }, // ちょ
        { { 'c','y','o', 0x00 }, { 0xe381a1, 0xe38287, 0x00 }, }, // ちょ
        { { 'c','h','o', 0x00 }, { 0xe381a1, 0xe38287, 0x00 }, }, // ちょ
        { { 't','w','u', 0x00 }, { 0xe381a8, 0xe38185, 0x00 }, }, // とぅ
        { { 't','a', 0x00 }, { 0xe3819f, 0x00 }, }, // た
        { { 't','i', 0x00 }, { 0xe381a1, 0x00 }, }, // ち
        { { 'c','h','i', 0x00 }, { 0xe381a1, 0x00 }, }, // ち
        { { 't','u', 0x00 }, { 0xe381a4, 0x00 }, }, // つ
        { { 't','s','u', 0x00 }, { 0xe381a4, 0x00 }, }, // つ
        { { 't','e', 0x00 }, { 0xe381a6, 0x00 }, }, // て
        { { 't','o', 0x00 }, { 0xe381a8, 0x00 }, }, // と
        { { 'b','b', 0x00 }, { 0xe381a3, 0x62, 0x00 }, }, // っb
        { { 'c','c', 0x00 }, { 0xe381a3, 0x63, 0x00 }, }, // っc
        { { 'd','d', 0x00 }, { 0xe381a3, 0x64, 0x00 }, }, // っd
        { { 'f','f', 0x00 }, { 0xe381a3, 0x66, 0x00 }, }, // っf
        { { 'g','g', 0x00 }, { 0xe381a3, 0x67, 0x00 }, }, // っg
        { { 'h','h', 0x00 }, { 0xe381a3, 0x68, 0x00 }, }, // っh
        { { 'j','j', 0x00 }, { 0xe381a3, 0x6a, 0x00 }, }, // っj
        { { 'k','k', 0x00 }, { 0xe381a3, 0x6b, 0x00 }, }, // っk
        { { 'l','l', 0x00 }, { 0xe381a3, 0x6c, 0x00 }, }, // っl
        { { 'm','m', 0x00 }, { 0xe381a3, 0x6d, 0x00 }, }, // っm
        { { 'p','p', 0x00 }, { 0xe381a3, 0x70, 0x00 }, }, // っp
        { { 'q','q', 0x00 }, { 0xe381a3, 0x71, 0x00 }, }, // っq
        { { 'r','r', 0x00 }, { 0xe381a3, 0x72, 0x00 }, }, // っr
        { { 's','s', 0x00 }, { 0xe381a3, 0x73, 0x00 }, }, // っs
        { { 't','t', 0x00 }, { 0xe381a3, 0x74, 0x00 }, }, // っt
        { { 'v','v', 0x00 }, { 0xe381a3, 0x76, 0x00 }, }, // っv
        { { 'w','w', 0x00 }, { 0xe381a3, 0x77, 0x00 }, }, // っw
        { { 'z','z', 0x00 }, { 0xe381a3, 0x7a, 0x00 }, }, // っz
        { { 'x','t','u', 0x00 }, { 0xe381a3, 0x00 }, }, // っ
        { { 'l','t','u', 0x00 }, { 0xe381a3, 0x00 }, }, // っ
        { { 'l','t','s','u', 0x00 }, { 0xe381a3, 0x00 }, }, // っ
        { { 'x','t','s','u', 0x00 }, { 0xe381a3, 0x00 }, }, // っ
        { { 'n','y','a', 0x00 }, { 0xe381ab, 0xe38283, 0x00 }, }, // にゃ
        { { 'n','y','i', 0x00 }, { 0xe381ab, 0xe38183, 0x00 }, }, // にぃ
        { { 'n','y','u', 0x00 }, { 0xe381ab, 0xe38285, 0x00 }, }, // にゅ
        { { 'n','y','e', 0x00 }, { 0xe381ab, 0xe38187, 0x00 }, }, // にぇ
        { { 'n','y','o', 0x00 }, { 0xe381ab, 0xe38287, 0x00 }, }, // にょ
        { { 'n','a', 0x00 }, { 0xe381aa, 0x00 }, }, // な
        { { 'n','i', 0x00 }, { 0xe381ab, 0x00 }, }, // に
        { { 'n','u', 0x00 }, { 0xe381ac, 0x00 }, }, // ぬ
        { { 'n','e', 0x00 }, { 0xe381ad, 0x00 }, }, // ね
        { { 'n','o', 0x00 }, { 0xe381ae, 0x00 }, }, // の
        { { 'h','y','a', 0x00 }, { 0xe381b2, 0xe38283, 0x00 }, }, // ひゃ
        { { 'h','y','i', 0x00 }, { 0xe381b2, 0xe38183, 0x00 }, }, // ひぃ
        { { 'h','y','u', 0x00 }, { 0xe381b2, 0xe38285, 0x00 }, }, // ひゅ
        { { 'h','y','e', 0x00 }, { 0xe381b2, 0xe38187, 0x00 }, }, // ひぇ
        { { 'h','y','o', 0x00 }, { 0xe381b2, 0xe38287, 0x00 }, }, // ひょ
        { { 'f','a', 0x00 }, { 0xe381b5, 0xe38181, 0x00 }, }, // ふぁ
        { { 'f','i', 0x00 }, { 0xe381b5, 0xe38183, 0x00 }, }, // ふぃ
        { { 'f','e', 0x00 }, { 0xe381b5, 0xe38187, 0x00 }, }, // ふぇ
        { { 'f','o', 0x00 }, { 0xe381b5, 0xe38189, 0x00 }, }, // ふぉ
        { { 'f','y','a', 0x00 }, { 0xe381b5, 0xe38181, 0x00 }, }, // ふぁ
        { { 'f','y','i', 0x00 }, { 0xe381b5, 0xe38183, 0x00 }, }, // ふぃ
        { { 'f','y','u', 0x00 }, { 0xe381b5, 0xe38285, 0x00 }, }, // ふゅ
        { { 'f','y','e', 0x00 }, { 0xe381b5, 0xe38187, 0x00 }, }, // ふぇ
        { { 'f','y','o', 0x00 }, { 0xe381b5, 0xe38287, 0x00 }, }, // ふょ
        { { 'h','a', 0x00 }, { 0xe381af, 0x00 }, }, // は
        { { 'h','i', 0x00 }, { 0xe381b2, 0x00 }, }, // ひ
        { { 'h','u', 0x00 }, { 0xe381b5, 0x00 }, }, // ふ
        { { 'f','u', 0x00 }, { 0xe381b5, 0x00 }, }, // ふ
        { { 'h','e', 0x00 }, { 0xe381b8, 0x00 }, }, // へ
        { { 'h','o', 0x00 }, { 0xe381bb, 0x00 }, }, // ほ
        { { 'm','y','a', 0x00 }, { 0xe381bf, 0xe38283, 0x00 }, }, // みゃ
        { { 'm','y','i', 0x00 }, { 0xe381bf, 0xe38183, 0x00 }, }, // みぃ
        { { 'm','y','u', 0x00 }, { 0xe381bf, 0xe38285, 0x00 }, }, // みゅ
        { { 'm','y','e', 0x00 }, { 0xe381bf, 0xe38187, 0x00 }, }, // みぇ
        { { 'm','y','o', 0x00 }, { 0xe381bf, 0xe38287, 0x00 }, }, // みょ
        { { 'm','a', 0x00 }, { 0xe381be, 0x00 }, }, // ま
        { { 'm','i', 0x00 }, { 0xe381bf, 0x00 }, }, // み
        { { 'm','u', 0x00 }, { 0xe38280, 0x00 }, }, // む
        { { 'm','e', 0x00 }, { 0xe38281, 0x00 }, }, // め
        { { 'm','o', 0x00 }, { 0xe38282, 0x00 }, }, // も
        { { 'y','a', 0x00 }, { 0xe38284, 0x00 }, }, // や
        { { 'y','i', 0x00 }, { 0xe38184, 0x00 }, }, // い
        { { 'y','u', 0x00 }, { 0xe38286, 0x00 }, }, // ゆ
        { { 'y','e', 0x00 }, { 0xe38184, 0xe38187, 0x00 }, }, // いぇ
        { { 'y','o', 0x00 }, { 0xe38288, 0x00 }, }, // よ
        { { 'r','y','a', 0x00 }, { 0xe3828a, 0xe38283, 0x00 }, }, // りゃ
        { { 'r','y','i', 0x00 }, { 0xe3828a, 0xe38183, 0x00 }, }, // りぃ
        { { 'r','y','u', 0x00 }, { 0xe3828a, 0xe38285, 0x00 }, }, // りゅ
        { { 'r','y','e', 0x00 }, { 0xe3828a, 0xe38187, 0x00 }, }, // りぇ
        { { 'r','y','o', 0x00 }, { 0xe3828a, 0xe38287, 0x00 }, }, // りょ
        { { 'r','a', 0x00 }, { 0xe38289, 0x00 }, }, // ら
        { { 'r','i', 0x00 }, { 0xe3828a, 0x00 }, }, // り
        { { 'r','u', 0x00 }, { 0xe3828b, 0x00 }, }, // る
        { { 'r','e', 0x00 }, { 0xe3828c, 0x00 }, }, // れ
        { { 'r','o', 0x00 }, { 0xe3828d, 0x00 }, }, // ろ
        { { 'w','a', 0x00 }, { 0xe3828f, 0x00 }, }, // わ
        { { 'w','i', 0x00 }, { 0xe38186, 0xe38183, 0x00 }, }, // うぃ
        { { 'w','u', 0x00 }, { 0xe38186, 0x00 }, }, // う
        { { 'w','e', 0x00 }, { 0xe38186, 0xe38187, 0x00 }, }, // うぇ
        { { 'w','o', 0x00 }, { 0xe38292, 0x00 }, }, // を
        { { 'l','w','a', 0x00 }, { 0xe3828f, 0x00 }, }, // わ
        { { 'x','w','a', 0x00 }, { 0xe3828f, 0x00 }, }, // わ
        { { 'n','b', 0x00 }, { 0xe38293, 0x62, 0x00 }, }, // んb
        { { 'n','c', 0x00 }, { 0xe38293, 0x63, 0x00 }, }, // んc
        { { 'n','d', 0x00 }, { 0xe38293, 0x64, 0x00 }, }, // んd
        { { 'n','f', 0x00 }, { 0xe38293, 0x66, 0x00 }, }, // んf
        { { 'n','g', 0x00 }, { 0xe38293, 0x67, 0x00 }, }, // んg
        { { 'n','h', 0x00 }, { 0xe38293, 0x68, 0x00 }, }, // んh
        { { 'n','j', 0x00 }, { 0xe38293, 0x6a, 0x00 }, }, // んj
        { { 'n','k', 0x00 }, { 0xe38293, 0x6b, 0x00 }, }, // んk
        { { 'n','l', 0x00 }, { 0xe38293, 0x6c, 0x00 }, }, // んl
        { { 'n','m', 0x00 }, { 0xe38293, 0x6d, 0x00 }, }, // んm
        { { 'n','p', 0x00 }, { 0xe38293, 0x70, 0x00 }, }, // んp
        { { 'n','q', 0x00 }, { 0xe38293, 0x71, 0x00 }, }, // んq
        { { 'n','r', 0x00 }, { 0xe38293, 0x72, 0x00 }, }, // んr
        { { 'n','s', 0x00 }, { 0xe38293, 0x73, 0x00 }, }, // んs
        { { 'n','t', 0x00 }, { 0xe38293, 0x74, 0x00 }, }, // んt
        { { 'n','v', 0x00 }, { 0xe38293, 0x76, 0x00 }, }, // んv
        { { 'n','w', 0x00 }, { 0xe38293, 0x77, 0x00 }, }, // んw
        { { 'n','z', 0x00 }, { 0xe38293, 0x7a, 0x00 }, }, // んz
        { { 'n','n', 0x00 }, { 0xe38293, 0x00 }, }, // ん
        { { 'n','\n', 0x00 }, { 0xe38293, 0x00 }, }, // ん
        { { 'n',',', 0x00 }, { 0xe38293, 0x2c, 0x00 }, }, // ん,
        { { 'n','.', 0x00 }, { 0xe38293, 0x2e, 0x00 }, }, // ん.
        { { 'g','y','a', 0x00 }, { 0xe3818e, 0xe38283, 0x00 }, }, // ぎゃ
        { { 'g','y','i', 0x00 }, { 0xe3818e, 0xe38183, 0x00 }, }, // ぎぃ
        { { 'g','y','u', 0x00 }, { 0xe3818e, 0xe38285, 0x00 }, }, // ぎゅ
        { { 'g','y','e', 0x00 }, { 0xe3818e, 0xe38187, 0x00 }, }, // ぎぇ
        { { 'g','y','o', 0x00 }, { 0xe3818e, 0xe38287, 0x00 }, }, // ぎょ
        { { 'g','w','a', 0x00 }, { 0xe38190, 0xe38181, 0x00 }, }, // ぐぁ
        { { 'g','a', 0x00 }, { 0xe3818c, 0x00 }, }, // が
        { { 'g','i', 0x00 }, { 0xe3818e, 0x00 }, }, // ぎ
        { { 'g','u', 0x00 }, { 0xe38190, 0x00 }, }, // ぐ
        { { 'g','e', 0x00 }, { 0xe38192, 0x00 }, }, // げ
        { { 'g','o', 0x00 }, { 0xe38194, 0x00 }, }, // ご
        { { 'j','a', 0x00 }, { 0xe38198, 0xe38283, 0x00 }, }, // じゃ
        { { 'j','y','a', 0x00 }, { 0xe38198, 0xe38283, 0x00 }, }, // じゃ
        { { 'z','y','a', 0x00 }, { 0xe38198, 0xe38283, 0x00 }, }, // じゃ
        { { 'j','y','i', 0x00 }, { 0xe38198, 0xe38183, 0x00 }, }, // じぃ
        { { 'z','y','i', 0x00 }, { 0xe38198, 0xe38183, 0x00 }, }, // じぃ
        { { 'j','u', 0x00 }, { 0xe38198, 0xe38285, 0x00 }, }, // じゅ
        { { 'j','y','u', 0x00 }, { 0xe38198, 0xe38285, 0x00 }, }, // じゅ
        { { 'z','y','u', 0x00 }, { 0xe38198, 0xe38285, 0x00 }, }, // じゅ
        { { 'j','e', 0x00 }, { 0xe38198, 0xe38187, 0x00 }, }, // じぇ
        { { 'j','y','e', 0x00 }, { 0xe38198, 0xe38187, 0x00 }, }, // じぇ
        { { 'z','y','e', 0x00 }, { 0xe38198, 0xe38187, 0x00 }, }, // じぇ
        { { 'j','o', 0x00 }, { 0xe38198, 0xe38287, 0x00 }, }, // じょ
        { { 'j','y','o', 0x00 }, { 0xe38198, 0xe38287, 0x00 }, }, // じょ
        { { 'z','y','o', 0x00 }, { 0xe38198, 0xe38287, 0x00 }, }, // じょ
        { { 'z','a', 0x00 }, { 0xe38196, 0x00 }, }, // ざ
        { { 'z','i', 0x00 }, { 0xe38198, 0x00 }, }, // じ
        { { 'j','i', 0x00 }, { 0xe38198, 0x00 }, }, // じ
        { { 'z','u', 0x00 }, { 0xe3819a, 0x00 }, }, // ず
        { { 'z','e', 0x00 }, { 0xe3819c, 0x00 }, }, // ぜ
        { { 'z','o', 0x00 }, { 0xe3819e, 0x00 }, }, // ぞ
        { { 'd','y','a', 0x00 }, { 0xe381a2, 0xe38283, 0x00 }, }, // ぢゃ
        { { 'd','y','i', 0x00 }, { 0xe381a2, 0xe38183, 0x00 }, }, // ぢぃ
        { { 'd','y','u', 0x00 }, { 0xe381a2, 0xe38285, 0x00 }, }, // ぢゅ
        { { 'd','y','e', 0x00 }, { 0xe381a2, 0xe38187, 0x00 }, }, // ぢぇ
        { { 'd','y','o', 0x00 }, { 0xe381a2, 0xe38287, 0x00 }, }, // ぢょ
        { { 'd','h','a', 0x00 }, { 0xe381a7, 0xe38283, 0x00 }, }, // でゃ
        { { 'd','h','i', 0x00 }, { 0xe381a7, 0xe38183, 0x00 }, }, // でぃ
        { { 'd','h','u', 0x00 }, { 0xe381a7, 0xe38285, 0x00 }, }, // でゅ
        { { 'd','h','e', 0x00 }, { 0xe381a7, 0xe38187, 0x00 }, }, // でぇ
        { { 'd','h','o', 0x00 }, { 0xe381a7, 0xe38287, 0x00 }, }, // でょ
        { { 'd','w','u', 0x00 }, { 0xe381a9, 0xe38185, 0x00 }, }, // どぅ
        { { 'd','a', 0x00 }, { 0xe381a0, 0x00 }, }, // だ
        { { 'd','i', 0x00 }, { 0xe381a2, 0x00 }, }, // ぢ
        { { 'd','u', 0x00 }, { 0xe381a5, 0x00 }, }, // づ
        { { 'd','e', 0x00 }, { 0xe381a7, 0x00 }, }, // で
        { { 'd','o', 0x00 }, { 0xe381a9, 0x00 }, }, // ど
        { { 'b','a', 0x00 }, { 0xe381b0, 0x00 }, }, // ば
        { { 'b','i', 0x00 }, { 0xe381b3, 0x00 }, }, // び
        { { 'b','u', 0x00 }, { 0xe381b6, 0x00 }, }, // ぶ
        { { 'b','e', 0x00 }, { 0xe381b9, 0x00 }, }, // べ
        { { 'b','o', 0x00 }, { 0xe381bc, 0x00 }, }, // ぼ
        { { 'p','y','a', 0x00 }, { 0xe381b4, 0xe38283, 0x00 }, }, // ぴゃ
        { { 'p','y','i', 0x00 }, { 0xe381b4, 0xe38183, 0x00 }, }, // ぴぃ
        { { 'p','y','u', 0x00 }, { 0xe381b4, 0xe38285, 0x00 }, }, // ぴゅ
        { { 'p','y','e', 0x00 }, { 0xe381b4, 0xe38187, 0x00 }, }, // ぴぇ
        { { 'p','y','o', 0x00 }, { 0xe381b4, 0xe38287, 0x00 }, }, // ぴょ
        { { 'b','y','a', 0x00 }, { 0xe381b3, 0xe38283, 0x00 }, }, // びゃ
        { { 'b','y','i', 0x00 }, { 0xe381b3, 0xe38183, 0x00 }, }, // びぃ
        { { 'b','y','u', 0x00 }, { 0xe381b3, 0xe38285, 0x00 }, }, // びゅ
        { { 'b','y','e', 0x00 }, { 0xe381b3, 0xe38187, 0x00 }, }, // びぇ
        { { 'b','y','o', 0x00 }, { 0xe381b3, 0xe38287, 0x00 }, }, // びょ
        { { 'p','a', 0x00 }, { 0xe381b1, 0x00 }, }, // ぱ
        { { 'p','i', 0x00 }, { 0xe381b4, 0x00 }, }, // ぴ
        { { 'p','u', 0x00 }, { 0xe381b7, 0x00 }, }, // ぷ
        { { 'p','e', 0x00 }, { 0xe381ba, 0x00 }, }, // ぺ
        { { 'p','o', 0x00 }, { 0xe381bd, 0x00 }, }, // ぽ
        { { 'v','a', 0x00 }, { 0xe38186, 0xe3829b, 0xe38181, 0x00 }, }, // う゛ぁ
        { { 'v','i', 0x00 }, { 0xe38186, 0xe3829b, 0xe38183, 0x00 }, }, // う゛ぃ
        { { 'v','u', 0x00 }, { 0xe38186, 0xe3829b, 0x00 }, }, // う゛
        { { 'v','e', 0x00 }, { 0xe38186, 0xe3829b, 0xe38187, 0x00 }, }, // う゛ぇ
        { { 'v','o', 0x00 }, { 0xe38186, 0xe3829b, 0xe38189, 0x00 }, }, // う゛ぉ
        { { 'x','a', 0x00 }, { 0xe38181, 0x00 }, }, // ぁ
        { { 'l','a', 0x00 }, { 0xe38181, 0x00 }, }, // ぁ
        { { 'x','i', 0x00 }, { 0xe38183, 0x00 }, }, // ぃ
        { { 'l','i', 0x00 }, { 0xe38183, 0x00 }, }, // ぃ
        { { 'x','u', 0x00 }, { 0xe38185, 0x00 }, }, // ぅ
        { { 'l','u', 0x00 }, { 0xe38185, 0x00 }, }, // ぅ
        { { 'x','e', 0x00 }, { 0xe38187, 0x00 }, }, // ぇ
        { { 'l','e', 0x00 }, { 0xe38187, 0x00 }, }, // ぇ
        { { 'x','o', 0x00 }, { 0xe38189, 0x00 }, }, // ぉ
        { { 'l','o', 0x00 }, { 0xe38189, 0x00 }, }, // ぉ
        { { 'x','y','a', 0x00 }, { 0xe38283, 0x00 }, }, // ゃ
        { { 'l','y','a', 0x00 }, { 0xe38283, 0x00 }, }, // ゃ
        { { 'x','y','i', 0x00 }, { 0xe38183, 0x00 }, }, // ぃ
        { { 'l','y','u', 0x00 }, { 0xe38183, 0x00 }, }, // ぃ
        { { 'x','y','u', 0x00 }, { 0xe38285, 0x00 }, }, // ゅ
        { { 'l','y','u', 0x00 }, { 0xe38285, 0x00 }, }, // ゅ
        { { 'x','y','e', 0x00 }, { 0xe38187, 0x00 }, }, // ぇ
        { { 'l','y','e', 0x00 }, { 0xe38187, 0x00 }, }, // ぇ
        { { 'x','y','o', 0x00 }, { 0xe38287, 0x00 }, }, // ょ
        { { 'l','y','o', 0x00 }, { 0xe38287, 0x00 }, }, // ょ
        { { 'x','k','a', 0x00 }, { 0xe383b5, 0x00 }, }, // ヵ
        { { 'l','k','a', 0x00 }, { 0xe383b5, 0x00 }, }, // ヵ
        { { 'x','k','e', 0x00 }, { 0xe383b6, 0x00 }, }, // ヶ
        { { 'l','k','e', 0x00 }, { 0xe383b6, 0x00 }, }, // ヶ
        { { 0x00 }, { 0x00 }, }, // テーブルの終端
    };
};

#endif /* !ROMAN_CONVERT_TBL_H */
