#ifndef KANA_CONVERT_TBL_H
#define KANA_CONVERT_TBL_H

/*!
  \file
  \brief ローマ字・かな変換テーブル(自動生成)

  \author Satofumi KAMIMURA

  $Id: kana_table.h 1943 2011-03-01 01:11:26Z satofumi $
*/


namespace qrk {
    enum { KANA_CONVERT_SIZE_MAX = 3 };

    //! Kana 変換用の Unicode 配列
    const static unsigned long KanaTable[][2][3] = {
        { { 0x8b81e3, '@', 0x00 }, { 0xe3818c, 0x00 }, }, // が
        { { 0x8d81e3, '@', 0x00 }, { 0xe3818e, 0x00 }, }, // ぎ
        { { 0x8f81e3, '@', 0x00 }, { 0xe38190, 0x00 }, }, // ぐ
        { { 0x9181e3, '@', 0x00 }, { 0xe38192, 0x00 }, }, // げ
        { { 0x9381e3, '@', 0x00 }, { 0xe38194, 0x00 }, }, // ご
        { { 0x9581e3, '@', 0x00 }, { 0xe38196, 0x00 }, }, // ざ
        { { 0x9781e3, '@', 0x00 }, { 0xe38198, 0x00 }, }, // じ
        { { 0x9981e3, '@', 0x00 }, { 0xe3819a, 0x00 }, }, // ず
        { { 0x9b81e3, '@', 0x00 }, { 0xe3819c, 0x00 }, }, // ぜ
        { { 0x9d81e3, '@', 0x00 }, { 0xe3819e, 0x00 }, }, // ぞ
        { { 0x9f81e3, '@', 0x00 }, { 0xe381a0, 0x00 }, }, // だ
        { { 0xa181e3, '@', 0x00 }, { 0xe381a2, 0x00 }, }, // ぢ
        { { 0xa481e3, '@', 0x00 }, { 0xe381a5, 0x00 }, }, // づ
        { { 0xa681e3, '@', 0x00 }, { 0xe381a7, 0x00 }, }, // で
        { { 0xa881e3, '@', 0x00 }, { 0xe381a9, 0x00 }, }, // ど
        { { 0xaf81e3, '@', 0x00 }, { 0xe381b0, 0x00 }, }, // ば
        { { 0xb281e3, '@', 0x00 }, { 0xe381b3, 0x00 }, }, // び
        { { 0xb581e3, '@', 0x00 }, { 0xe381b6, 0x00 }, }, // ぶ
        { { 0xb881e3, '@', 0x00 }, { 0xe381b9, 0x00 }, }, // べ
        { { 0xbb81e3, '@', 0x00 }, { 0xe381bc, 0x00 }, }, // ぼ
        { { 0xaf81e3, '[', 0x00 }, { 0xe381b1, 0x00 }, }, // ぱ
        { { 0xb281e3, '[', 0x00 }, { 0xe381b4, 0x00 }, }, // ぴ
        { { 0xb581e3, '[', 0x00 }, { 0xe381b7, 0x00 }, }, // ぷ
        { { 0xb881e3, '[', 0x00 }, { 0xe381ba, 0x00 }, }, // ぺ
        { { 0xbb81e3, '[', 0x00 }, { 0xe381bd, 0x00 }, }, // ぽ
        { { '1', 0x00 }, { 0xe381ac, 0x00 }, }, // ぬ
        { { '2', 0x00 }, { 0xe381b5, 0x00 }, }, // ふ
        { { '3', 0x00 }, { 0xe38182, 0x00 }, }, // あ
        { { '4', 0x00 }, { 0xe38186, 0x00 }, }, // う
        { { '5', 0x00 }, { 0xe38188, 0x00 }, }, // え
        { { '6', 0x00 }, { 0xe3818a, 0x00 }, }, // お
        { { '7', 0x00 }, { 0xe38284, 0x00 }, }, // や
        { { '8', 0x00 }, { 0xe38286, 0x00 }, }, // ゆ
        { { '9', 0x00 }, { 0xe38288, 0x00 }, }, // よ
        { { '0', 0x00 }, { 0xe3828f, 0x00 }, }, // わ
        { { '-', 0x00 }, { 0xe381bb, 0x00 }, }, // ほ
        { { '^', 0x00 }, { 0xe381b8, 0x00 }, }, // へ
        { { 'q', 0x00 }, { 0xe3819f, 0x00 }, }, // た
        { { 'w', 0x00 }, { 0xe381a6, 0x00 }, }, // て
        { { 'e', 0x00 }, { 0xe38184, 0x00 }, }, // い
        { { 'r', 0x00 }, { 0xe38199, 0x00 }, }, // す
        { { 't', 0x00 }, { 0xe3818b, 0x00 }, }, // か
        { { 'y', 0x00 }, { 0xe38293, 0x00 }, }, // ん
        { { 'u', 0x00 }, { 0xe381aa, 0x00 }, }, // な
        { { 'i', 0x00 }, { 0xe381ab, 0x00 }, }, // に
        { { 'o', 0x00 }, { 0xe38289, 0x00 }, }, // ら
        { { 'p', 0x00 }, { 0xe3819b, 0x00 }, }, // せ
        { { '@', 0x00 }, { 0xe3829b, 0x00 }, }, // ゛
        { { '[', 0x00 }, { 0xe3829c, 0x00 }, }, // ゜
        { { 'a', 0x00 }, { 0xe381a1, 0x00 }, }, // ち
        { { 's', 0x00 }, { 0xe381a8, 0x00 }, }, // と
        { { 'd', 0x00 }, { 0xe38197, 0x00 }, }, // し
        { { 'f', 0x00 }, { 0xe381af, 0x00 }, }, // は
        { { 'g', 0x00 }, { 0xe3818d, 0x00 }, }, // き
        { { 'h', 0x00 }, { 0xe3818f, 0x00 }, }, // く
        { { 'j', 0x00 }, { 0xe381be, 0x00 }, }, // ま
        { { 'k', 0x00 }, { 0xe381ae, 0x00 }, }, // の
        { { 'l', 0x00 }, { 0xe3828a, 0x00 }, }, // り
        { { ';', 0x00 }, { 0xe3828c, 0x00 }, }, // れ
        { { ':', 0x00 }, { 0xe38191, 0x00 }, }, // け
        { { ']', 0x00 }, { 0xe38280, 0x00 }, }, // む
        { { 'z', 0x00 }, { 0xe381a4, 0x00 }, }, // つ
        { { 'x', 0x00 }, { 0xe38195, 0x00 }, }, // さ
        { { 'c', 0x00 }, { 0xe3819d, 0x00 }, }, // そ
        { { 'v', 0x00 }, { 0xe381b2, 0x00 }, }, // ひ
        { { 'b', 0x00 }, { 0xe38193, 0x00 }, }, // こ
        { { 'n', 0x00 }, { 0xe381bf, 0x00 }, }, // み
        { { 'm', 0x00 }, { 0xe38282, 0x00 }, }, // も
        { { ',', 0x00 }, { 0xe381ad, 0x00 }, }, // ね
        { { '.', 0x00 }, { 0xe3828b, 0x00 }, }, // る
        { { '/', 0x00 }, { 0xe38281, 0x00 }, }, // め
        { { '\\', 0x00 }, { 0xe3828d, 0x00 }, }, // ろ
        { { '#', 0x00 }, { 0xe38181, 0x00 }, }, // ぁ
        { { 'E', 0x00 }, { 0xe38183, 0x00 }, }, // ぃ
        { { '$', 0x00 }, { 0xe38185, 0x00 }, }, // ぅ
        { { '%', 0x00 }, { 0xe38187, 0x00 }, }, // ぇ
        { { '&', 0x00 }, { 0xe38189, 0x00 }, }, // ぉ
        { { '\'', 0x00 }, { 0xe38283, 0x00 }, }, // ゃ
        { { '(', 0x00 }, { 0xe38285, 0x00 }, }, // ゅ
        { { ')', 0x00 }, { 0xe38287, 0x00 }, }, // ょ
        { { '~', 0x00 }, { 0xe38292, 0x00 }, }, // を
        { { 'Z', 0x00 }, { 0xe381a3, 0x00 }, }, // っ
        { { 0x00 }, { 0x00 }, }, // テーブルの終端
    };
};

#endif /* !KANA_CONVERT_TBL_H */
