/*!
  \file
  \brief convertToJp.cpp のテスト

  \author Satofumi KAMIMURA

  $Id: TestConvertToJp.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "TestConvertToJp.h"
#include "convertToJp.h"
#include "Utf8.h"

using namespace qrk;
using namespace std;

CPPUNIT_TEST_SUITE_REGISTRATION(TestConvertToJp);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestConvertToJp, "TestConvertToJp");


// ローマ字変換のテスト
void TestConvertToJp::romanConvertTest(void)
{
    Utf8 actual = Utf8(convertToJp("a"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("あ")[0], actual[0]);

    actual = Utf8(convertToJp("asa"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("あ")[0], actual[0]);
    CPPUNIT_ASSERT_EQUAL(Utf8("さ")[0], actual[1]);

    actual = Utf8(convertToJp("asy"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("あ")[0], actual[0]);
    CPPUNIT_ASSERT_EQUAL(Utf8("s")[0], actual[1]);
    CPPUNIT_ASSERT_EQUAL(Utf8("y")[0], actual[2]);

    actual = Utf8(convertToJp("asya"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("あ")[0], actual[0]);
    CPPUNIT_ASSERT_EQUAL(Utf8("し")[0], actual[1]);
    CPPUNIT_ASSERT_EQUAL(Utf8("ゃ")[0], actual[2]);

    actual = Utf8(convertToJp("xa"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("ぁ")[0], actual[0]);

    actual = Utf8(convertToJp("cba"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("c")[0], actual[0]);
    CPPUNIT_ASSERT_EQUAL(Utf8("ば")[0], actual[1]);

    actual = Utf8(convertToJp("kk"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("っ")[0], actual[0]);
    CPPUNIT_ASSERT_EQUAL(Utf8("k")[0], actual[1]);

    actual = Utf8(convertToJp("kka"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("っ")[0], actual[0]);
    CPPUNIT_ASSERT_EQUAL(Utf8("か")[0], actual[1]);

    actual = Utf8(convertToJp("shi"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("し")[0], actual[0]);

    actual = Utf8(convertToJp("si"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("し")[0], actual[0]);

    actual = Utf8(convertToJp("あ"));
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), actual.size());
    CPPUNIT_ASSERT_EQUAL(Utf8("あ")[0], actual[0]);
}
