/*!
  \example canvasSample.cpp

  オブジェクトの描画

  \author Satofumi KAMIMURA

  $Id: canvasDraw.cpp 1950 2011-05-07 08:18:39Z satofumi $
*/

#include "Screen.h"
#include "CanvasSurface.h"
#include "Label.h"

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
    static_cast<void>(argc);
    static_cast<void>(argv);

    Screen screen;
    screen.show(SDL_OPENGL);

    CanvasSurface canvas(Rect<long>(0, 0, 100, 100));

    screen.clear();
    //Rect<long> dest_rect = canvas.rect();

    canvas.setClearColor(Color(0.5, 0.5, 0.5));
    canvas.setColor(Color(0.0, 0.0, 1.0));

    vector<Point<long> > points;
#if 1
    for (int i = 1; i < 5; ++i) {
        points.clear();
        points.push_back(Point<long>(10 * i, 10 * i));
        points.push_back(Point<long>(10 * i, canvas.rect().h - (10 * i)));
        points.push_back(Point<long>(canvas.rect().w - (10 * i),
                                     canvas.rect().h - (10 * i)));
        points.push_back(Point<long>(canvas.rect().w - (10 * i), 10 * i));
        canvas.drawLineLoop(points);
    }

    Label label(canvas);
    label.setPosition(Point<long>(30, 30));

    Rect<long> dest(label.rect());
    label.draw(dest);

#else
    canvas.setLineWidth(1.0);
    points.push_back(Point<long>(30, 1));
    points.push_back(Point<long>(50, 1));
    points.push_back(Point<long>(50, 100));
    points.push_back(Point<long>(70, 100));
    canvas.drawLineStrip(points);

    canvas.setLineWidth(2.0);
    points.clear();
    points.push_back(Point<long>(0, 0));
    points.push_back(Point<long>(100, 100));
    canvas.drawLineStrip(points);

    points.clear();
    canvas.setColor(Color(1.0, 0.0, 1.0));
    points.push_back(Point<long>(0, 20));
    points.push_back(Point<long>(0, 40));
    points.push_back(Point<long>(40, 60));
    points.push_back(Point<long>(40, 80));
    points.push_back(Point<long>(80, 40));
    points.push_back(Point<long>(80, 60));
    points.push_back(Point<long>(100, 80));
    points.push_back(Point<long>(100, 100));
    canvas.drawQuadStrip(points);

    canvas.draw(NULL, &dest_rect);
#endif

    SDL_GL_SwapBuffers();
    SDL_Delay(1000);

    return 0;
}
