#ifndef QRK_TEXT_RUBI_FADE_SURFACE_H
#define QRK_TEXT_RUBI_FADE_SURFACE_H

/*!
  \file
  \brief ルビ付きの部分透過できる文字列サーフェス

  \author Satofumi KAMIMURA

  $Id: TextRubiFadeSurface.h 1950 2011-05-07 08:18:39Z satofumi $
*/

#include "Surface.h"
#include <memory>
#include <cstddef>


namespace qrk
{
    class Font;


    //! ルビ付きの部分透過できる文字列サーフェス
    class TextRubiFadeSurface : public Surface
    {
    public:
        explicit TextRubiFadeSurface(const Font& font, const char* text,
                                     const Font& rubi_font,
                                     const char* kana_only_text);
        ~TextRubiFadeSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

        // !!! フェードのモードを指定するメソッド
        void setFadePercent(size_t percent);

    private:
        TextRubiFadeSurface(void);
        TextRubiFadeSurface(const TextRubiFadeSurface& rhs);
        TextRubiFadeSurface& operator = (const TextRubiFadeSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_TEXT_RUBI_FADE_SURFACE_H */
