#ifndef TEXT_FADE_SURFACE_H
#define TEXT_FADE_SURFACE_H

/*!
  \file
  \brief 部分透過できる文字列サーフェス

  \author Satofumi KAMIMURA

  $Id: TextFadeSurface.h 1813 2010-05-01 14:21:29Z satofumi $
*/

#include "Surface.h"
#include <cstddef>
#include <memory>


namespace qrk
{
    class Font;


    //! 部分透過できる文字列サーフェス
    class TextFadeSurface : public Surface
    {
    public:
        explicit TextFadeSurface(const Font& font, const char* text);
        ~TextFadeSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

        // !!! フェードのモードを指定するメソッド
        void setFadePercent(size_t percent);

    private:
        TextFadeSurface(void);
        TextFadeSurface(const TextFadeSurface& rhs);
        TextFadeSurface& operator = (const TextFadeSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !TEXT_FADE_SURFACE_H */
