#ifndef QRK_SURFACE_H
#define QRK_SURFACE_H

/*!
  \file
  \brief サーフェスのインターフェース定義

  \author Satofumi KAMIMURA

  $Id: Surface.h 1815 2010-05-06 17:34:19Z satofumi $
*/

#include "Rect.h"


namespace qrk
{
    class Angle;


    //! サーフェスのインターフェース定義
    class Surface
    {
    public:
        virtual ~Surface(void)
        {
        }


        /*!
          \brief サーフェスが有効かを返す

          リソース等の理由で、サーフェスを生成できない場合に false になる。

          \retval true サーフェスは有効
          \retval false サーフェスが無効
        */
        virtual bool isValid(void) const = 0;


        virtual Rect<long> rect(void) const = 0;
        virtual void setAlpha(float alpha) = 0;
        virtual float alpha(void) const = 0;
        virtual void setRotateAngle(const Angle& angle) = 0;


        /*!
          \brief 描画

          \todo src, dest の意味を記述する
        */
        virtual void draw(const Rect<long>* src, const Rect<long>* dest) = 0;
    };
}

#endif /* !QRK_SURFACE_H */
