#ifndef QRK_SLIDE_SELECT_H
#define QRK_SLIDE_SELECT_H

/*!
  \file
  \brief 項目のセレクタを移動させて決定を促す選択コンポーネント

  \author Satofumi KAMIMURA

  $Id: SlideSelect.h 1942 2011-01-30 22:41:36Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
    class SlideSelect : public Component
    {
    public:
        SlideSelect(void);
        ~SlideSelect(void);

        Rect<long> rect(void) const;
        void setEventAcceptable(bool acceptable);
        void setAlpha(float alpha);
        float alpha(void);
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>& area);

    private:
        SlideSelect(const SlideSelect& rhs);
        SlideSelect& operator = (const SlideSelect& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_SLIDE_SELECT_H */


/*!
  \page slide_select_h_page 項目のセレクタを移動させて決定を促す選択コンポーネント

  - 特殊なメニューコンポーネントとして扱う
    - というか Menu コンポーネントを使うことにして、このコンポーネントは破棄する。
*/
