#ifndef QRK_MENU_H
#define QRK_MENU_H

/*!
  \file
  \brief メニュー

  \author Satofumi KAMIMURA

  $Id: Menu.h 1957 2011-07-27 23:13:30Z satofumi $
*/

#include "Component.h"
#include <boost/signals.hpp>


namespace qrk
{
    typedef boost::signal<void (size_t)> ButtonIdCallback;


    //! メニュー
    class Menu : public Component
    {
    public:
        enum {
            InvalidIndex = -1,
            InvalidId = boost::integer_traits<int>::const_max,
        };

        typedef enum {
            Left = 0x01,
            Center = 0x02,
            Right = 0x04,

            Top = 0x10,
            Middle = 0x20,
            Bottom = 0x40,
        } Align;


        typedef enum {
            Verbatim,
            Horizontal,
        } Axis;


        /*!
          \brief コンストラクタ

          \bug Middle と Center を同時に指定したときの位置がおかしい。
        */
        Menu(const Rect<long>& rect, int align = Left, Axis axis = Verbatim);
        ~Menu(void);

        Rect<long> rect(void) const;
        void setEventAcceptable(bool acceptable);
        void setAlpha(float alpha);
        float alpha(void);
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>& area);

        void setButtonStep(const Point<long>& step);
        void addButton(Component& button, size_t id);
        void removeButton(size_t id);
        void setButtonEnabled(size_t id, bool enable);

        void setEnableNoSelect(bool enable);
        void setEnableRotate(bool enable);

        /*!
          \brief 選択が決定された状態においても他の項目を選択できるようにする

          ある項目が選択が行われた場合は、他の選択は無効になる。
        */
        void setEnableClickedAndFocus(bool enable);

        bool empty(void);
        size_t indexSize(void);

        void setFocus(size_t id);
        void press(size_t id);
        void release(size_t id);
        void release(void);

        void setIndex(int index);
        int index(void) const;
        bool isClicked(void) const;
        size_t clickedId(void) const;
        int clickedIndex(void) const;

        void registerIconLabel(Component& icon_label, bool draw_front = true);
        void unregisterIconLabel(void);
        void setIconOffset(const Point<long>& offset);

        void connectPressedEvent(ButtonIdCallback::slot_type& slot);

    private:
        Menu(void);
        Menu(const Menu& rhs);
        Menu& operator = (const Menu& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_MENU_H */
