#ifndef QRK_LABLE_H

#define QRK_LABLE_H

/*!
  \file
  \brief ラベル

  \author Satofumi KAMIMURA

  $Id: Label.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
    class Surface;


    //! ラベル
    class Label : public Component
    {
    public:
        explicit Label(Surface& surface);
        ~Label(void);

        Rect<long> rect(void) const;
        void setEventAcceptable(bool acceptable);
        void setAlpha(float alpha);
        float alpha(void);
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>& area);

    private:
        Label(const Label& rhs);
        Label& operator = (Label& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_LABLE_H */
