/*!
  \file
  \brief 画像サーフェスの作成

  \author Satofumi KAMIMURA

  $Id: ImageSurface.cpp 1815 2010-05-06 17:34:19Z satofumi $
*/

#include "ImageSurface.h"
#include "SDL_GL_Texture.h"
#include "log_printf.h"
#include <SDL_image.h>

using namespace qrk;


struct ImageSurface::pImpl
{
    SDL_GL_Texture texture_;
    Rect<long> rect_;


    pImpl(const char* file, bool transparent)
        : texture_(IMG_Load(file), transparent),
          rect_(0, 0, static_cast<long>(texture_.w),
                static_cast<long>(texture_.h))
    {
        if (! texture_.isValid()) {
            log_printf("%s is not found.\n", file);
        }
    }
};


ImageSurface::ImageSurface(const char* file, bool transparent)
    : pimpl(new pImpl(file, transparent))
{
}


ImageSurface::~ImageSurface(void)
{
}


bool ImageSurface::isValid(void) const
{
    return pimpl->texture_.isValid();
}


Rect<long> ImageSurface::rect(void) const
{
    return pimpl->rect_;
}


void ImageSurface::setAlpha(float alpha)
{
    pimpl->texture_.setAlpha(alpha);
}


float ImageSurface::alpha(void) const
{
    return pimpl->texture_.alpha();
}


void ImageSurface::setRotateAngle(const Angle& angle)
{
    pimpl->texture_.setRotateAngle(angle);
}


void ImageSurface::draw(const Rect<long>* src, const Rect<long>* dest)
{
    if (! pimpl->texture_.isValid()) {
        return;
    }
    pimpl->texture_.blitTexture(src, dest);
}
