#ifndef QRK_EVENT_MANAGER_H
#define QRK_EVENT_MANAGER_H

/*!
  \file
  \brief イベント管理

  \author Satofumi KAMIMURA

  $Id: EventManager.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Point.h"
#include <SDL.h>
#include <memory>


namespace qrk
{
    class Event;


    //! イベント管理
    class EventManager
    {
    public:
        EventManager(void);
        ~EventManager(void);

        void clear(void);
        void insert(Event* event);
        void remove(Event* event);

        void checkKey(SDLKey key, Uint8 type, SDLMod mod, Uint16 unicode);
        void checkClick(Uint8 mouse_button, Uint8 type);
        void checkEnterCursor(const Point<long>& current,
                              const Point<long>& previous);
        void cursorMoved(void);

    private:
        EventManager(const EventManager& rhs);
        EventManager& operator = (const EventManager& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_EVENT_MANAGER_H */
