#ifndef QRK_CANVAS_SURFACE_H
#define QRK_CANVAS_SURFACE_H

/*!
  \file
  \brief 描画サーフェス

  \author Satofumi KAMIMURA

  $Id: CanvasSurface.h 1932 2010-10-02 21:46:01Z satofumi $
*/

#include "Surface.h"
#include "Rect.h"
#include "Point.h"
#include "Color.h"
#include <vector>
#include <memory>


namespace qrk
{
    class Font;


    class CanvasSurface : public Surface
    {
    public:
        CanvasSurface(const qrk::Rect<long>& rect);
        ~CanvasSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

        void setFont(qrk::Font& font);
        Font* font(void) const;
        void setClearColor(const qrk::Color& color);
        void clear(void);

        // !!! drawText() の色は、登録した Font オブジェクトで調整すること
        void setColor(const qrk::Color& color);
        void setPointSize(float size);
        void setLineWidth(float width);
        void setLineStipple(int factor, unsigned short pattern);

        void drawPoints(const std::vector<qrk::Point<long> >& points);
        void drawLineStrip(const std::vector<qrk::Point<long> >& points);
        void drawLineLoop(const std::vector<qrk::Point<long> >& points);
        void drawCircle(const qrk::Point<long>& center, float radius);
        void drawQuadStrip(const std::vector<qrk::Point<long> >& points);
        void drawText(const char* text, const Point<long>& position);

    private:
        CanvasSurface(const CanvasSurface& rhs);
        CanvasSurface& operator = (CanvasSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_CANVAS_SURFACE_H */
