#ifndef QRK_STR_01_H
#define QRK_STR_01_H

namespace qrk
{
  enum {
    Max = 12,
  };


  /*!
    \brief ベクトルの定義
  */
  typedef struct {
    int n;                         /* size of vector */
    double a[Max];                 /* elements of vector */
    int err;                       /* err=1: error */
  } vector;


  /*!
    \brief 行列の定義
  */
  typedef struct {
    int n;                         /* size of raw */
    int m;                         /* size of columb */
    double a[Max][Max];            /* elements of matrix */
    char message[80];              /* error report */
    int err;                       /* err=1: error */
  } matrix;
}

#endif /* !QRK_STR_01_H */
