/*!
  \example gpsCtrlSample.cpp

  \brief GpsCtrl の利用サンプル

  \author Satofumi KAMIMURA

  $Id: gpsCtrlSample.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "mGpsCtrl.h"
#include "NmeaData.h"
#include "delay.h"
#include <cstdio>
#include <cstdlib>

using namespace qrk;


int main(int argc, char *argv[])
{
  mGpsCtrl gps(argc, argv);
  if (! gps.connect("/dev/usb/ttyUSB0", 4800)) {
    printf("GpsCtrl::connect: %s\n", gps.what());
    exit(1);
  }

  NmeaData nmea;
  bool origin_initialized = false;
  while (1) {
    delay(1000);
    gps.update(&nmea);

    if (! nmea.validPosition()) {
      continue;
    }

    if (! origin_initialized) {
      origin_initialized = true;
      nmea.setOrigin(nmea.latitude, nmea.longitude);
    }

    Position<long> position = nmea.position(nmea.latitude, nmea.longitude);
    printf("%ld\t%ld\n", position.x, position.y);
    fflush(stdout);
  }
}
