/*!
  \file
  \brief AngleUtils のテスト

  \author Satofumi KAMIMURA

  $Id: TestAngleUtils.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "TestAngleUtils.h"
#include "AngleUtils.h"

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestAngleUtils);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestAngleUtils, "TestAngleUtils");


void TestAngleUtils::narrowAngleTest(void)
{
    Angle angle;

    angle = narrowAngle(Point<long>(0, 0),
                        Point<long>(1, 0),
                        Point<long>(1, 1));
    CPPUNIT_ASSERT_EQUAL(-90, angle.to_deg());

    angle = narrowAngle(Point<long>(0, 0),
                        Point<long>(1, 0),
                        Point<long>(2, 0));
    CPPUNIT_ASSERT_EQUAL(180, angle.to_deg());

    angle = narrowAngle(Point<long>(0, 0),
                        Point<long>(1, 0),
                        Point<long>(1, -1));
    CPPUNIT_ASSERT_EQUAL(90, angle.to_deg());

    angle = narrowAngle(Point<long>(0, 0),
                        Point<long>(-1, 0),
                        Point<long>(0, 1));
    CPPUNIT_ASSERT_EQUAL(45, angle.to_deg());

    angle = narrowAngle(Point<long>(0, 0),
                        Point<long>(-1, 0),
                        Point<long>(0, -1));
    CPPUNIT_ASSERT_EQUAL(-45, angle.to_deg());

    angle = narrowAngle(Point<long>(1, 1),
                        Point<long>(0, 1),
                        Point<long>(0, 0));
    CPPUNIT_ASSERT_EQUAL(-90, angle.to_deg());
}
