#ifndef QRK_POINT_UTILS_H
#define QRK_POINT_UTILS_H

/*!
  \file
  \brief Point の補助関数

  \author Satofumi KAMIMURA

  $Id: PointUtils.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "MathUtils.h"


namespace qrk
{
    /*!
      \brief 長さの計算

      \param[in] a 点 a
      \param[in] b 点 b

      \return ２点間の距離
    */
    template <class T>
    T length(const Point<T>& a, const Point<T>& b)
    {
        T x_diff = a.x - b.x;
        T y_diff = a.y - b.y;
        return static_cast<T>(sqrt((x_diff * x_diff) + (y_diff * y_diff)));
    }


    template <class T>
    Point<T> calculateXy(T length, double radian)
    {
        T x = static_cast<T>(length * cos(radian));
        T y = static_cast<T>(length * sin(radian));

        return Point<T>(x, y);
    }
}

#endif /* !QRK_POINT_UTILS_H */
