#ifndef SCI_PUT_H
#define SCI_PUT_H

/*!
  \file
  \brief SCI の出力補助

  \author Satofumi KAMIMURA

  $Id: sci_put.h 1623 2010-01-16 12:15:44Z satofumi $
*/


extern int sci_putc(const char ch);


/*!
  \brief 文字列の送信

  \param[in] data '\0' 終端の文字列データ

  \return 送信した文字数
*/
extern int sci_puts(const char* data);


/*!
  \brief 数値の送信

  \param[in] value 数値

  \return 送信した文字数
*/
extern int sci_putint(long value);


/*!
  \brief 16進数での数値の送信

  \param[in] value 数値
  \param[in] byte_size バイト数

  \return 送信した文字数
*/
extern int sci_puthex(unsigned long value, int byte_size);


#endif /* !SCI_PUT_H */
