/*!
  \file
  \brief mot ファイルの RAM への配置プログラム

  \author Satofumi KAMIMURA

  $Id: loader.c 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "mot_handler.h"
#include "sci_control.h"
#include "sci_get.h"
#include "imask_control.h"


static void jumpAddress(unsigned long address)
{
    typedef int (*first_code)(void);
    first_code start = (first_code)address;
    start();
}


// 文字列の最後に '\0' を格納して返す
static int readLine(char *line, int max_size)
{
    char *p = line;
    char ch;

    while (((ch = sci_getc()) != '\n') && ((p - line) < (max_size - 1))) {
        if ((ch == -1) || (ch == '\r') || (ch == '\n')) {
            continue;
        }
        *p++ = ch;
    }
    *p = '\0';

    return (p - line);
}


int main(void)
{
    // シリアル通信の初期化
    sci_initialize(5, 38400);
    imask_setMaskLevel(0);

    // RAM の先頭アドレスをデフォルト値とする
    unsigned long start_address = 0xffffa000;

    // データの読み出し
    enum { BufferSize = 128 };
    char buffer[BufferSize];

    while (readLine(buffer, BufferSize) > 0) {
        mot_t mot;
        int type = mot_parse(&mot, buffer);

        if ((type >= 1) && (type <= 3)) {
            mot_place(&mot);
        } else if (type >= 7) {
            start_address = mot.address;
        }
    }

    imask_setMaskLevel(15);
    jumpAddress(start_address);

    while (1) {
        ;
    }
}
