/*!
  \example
  \brief UsbJoystick の動作サンプル

  \author Satofumi KAMIMURA

  \todo 強制終了の方法を定義する

  $Id: usbJoystickSample.cpp 1932 2010-10-02 21:46:01Z satofumi $
*/

#include "mUsbJoystick.h"
#include "Screen.h"
#include "ViewJoystickInfo.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  // Joystick 動作には、SDL のスクリーンが必要
  Screen screen;
  //screen.show();

  // 最初に認識した Joystick と接続を確立する
  mUsbJoystick joystick(argc, argv);
  if (! joystick.connect()) {
    printf("UsbJoystick::connect: %s\n", joystick.what());
    exit(1);
  }
  printf("Found joystick: %d\n", joystick.joystickNum());

  // ジョイスティック情報の取得、表示
  ViewJoystickInfo(joystick);

  return 0;
}
