/*!
  \file
  \brief SDL 対応ジョイスティックの初期化

  \author Satofumi KAMIMURA

  $Id: SdlJoystickInit.cpp 775 2009-05-05 08:05:45Z satofumi $
*/

#include "SdlJoystickInit.h"
#include "SdlInit.h"
#include <SDL.h>

using namespace qrk;


/*!
  \brief SdlJoystickInit の内部クラス
*/
struct SdlJoystickInit::pImpl : private SdlInit
{
  static bool initialized_;

  static void joystickQuit(void)
  {
    SDL_QuitSubSystem(SDL_INIT_JOYSTICK);
  }
};

bool SdlJoystickInit::pImpl::initialized_ = false;


SdlJoystickInit::SdlJoystickInit(void) : pimpl(new pImpl)
{
  if (pimpl->initialized_ == false) {
    if (SDL_InitSubSystem(SDL_INIT_JOYSTICK)) {
      // !!! エラーメッセージの表示
      return;
    }
    atexit(pImpl::joystickQuit);
    SDL_JoystickEventState(SDL_ENABLE);

    pimpl->initialized_ = true;
  }
}


SdlJoystickInit::~SdlJoystickInit(void)
{
}
