/*!
  \example controller/samples/recordAccelerationSample.cpp

  Wii 加速度情報の出力サンプル

  \author Satofumi KAMIMURA

  $Id: recordAccelerationSample.cpp 1727 2010-02-26 08:56:46Z satofumi $
*/

#include "WiiJoystick.h"
#include "ticks.h"
#include "delay.h"
#include <cstdio>
#include <cstdlib>

using namespace qrk;


#if 0
namespace
{
  typedef deque<WiiJoystick::Acceleration> Accelerations;
}
#endif


int main(int argc, char *argv[])
{
  WiiJoystick joystick;
  if (! joystick.connect()) {
    printf("WiiJoystick::connect: %s\n", joystick.what());
    exit(1);
  }

  fprintf(stderr, "press return to record.\n");
  getchar();

  enum { RecordMsec = 3000 };
  int first_ticks = ticks();
  while ((ticks() - first_ticks) < RecordMsec) {

    Point3d<double> acceleration;
    joystick.acceleration(acceleration);
    printf("%ld,\t%.2f, %.2f, %.2f\n",
           ticks(), acceleration.x, acceleration.y, acceleration.z);

    delay(10);
  }

  return 0;
}
