#ifndef QRK_JOYSTICK_H
#define QRK_JOYSTICK_H

/*!
  \file
  \brief ジョイスティックのインターフェース

  \author Satofumi KAMIMURA

  $Id: Joystick.h 1386 2009-10-09 08:00:11Z satofumi $
*/

#include <cstddef>


namespace qrk
{
  //! ジョイスティックのインターフェース
  class Joystick
  {
  public:
    virtual ~Joystick(void)
    {
    }


    /*!
      \brief イベントの登録

      SDL 実装のときに用いる。

      \param[in] event イベント
    */
    virtual void setEvent(void* event)
    {
      static_cast<void>(event);
    }


    /*!
      \brief 状態の取得

      \return 状態を示す文字列
    */
    virtual const char* what(void) const = 0;


    /*!
      \brief 接続

      \param[in] id 接続デバイスの番号

      \retval true 成功
      \retval false 失敗
    */
    virtual bool connect(int id) = 0;


    /*!
      \brief 切断
    */
    virtual void disconnect(void) = 0;


    /*!
      \brief 接続状態を返す

      \retval true 接続中
      \retval false 切断中
    */
    virtual bool isConnected(void) const = 0;


    /*!
      \brief 軸の数を取得

      \return 軸の数
    */
    virtual size_t axisNum(void) const = 0;


    /*!
      \brief 軸の入力値を取得

      \param[in] index 軸の番号

      \return 軸の入力値
    */
    virtual int axisValue(size_t index) = 0;


    /*!
      \brief ボタンの数を取得

      \return ボタンの数
    */
    virtual size_t buttonsNum(void) const = 0;


    /*!
      \brief ボタン押下情報の取得

      \param[in] index ボタンの番号

      \retval true 押されている
      \retval false 離されている
    */
    virtual bool isButtonPressed(size_t index) = 0;
  };
}

#endif /* !QRK_JOYSTICK_H */
